"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutSummaryKpis = FlyoutSummaryKpis;
exports.FlyoutSummaryKpisLoading = FlyoutSummaryKpisLoading;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _es_fields = require("../../../../common/es_fields");
var _utils = require("../../../utils");
var _telemetry = require("../../../services/telemetry");
var _hooks = require("../../../hooks");
var _flyout_summary_kpi_item = require("./flyout_summary_kpi_item");
var _get_summary_kpis = require("./get_summary_kpis");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FlyoutSummaryKpis({
  dataStreamStat,
  dataStreamDetails,
  isLoading,
  timeRange
}) {
  const {
    services: {
      observabilityShared
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const telemetry = (0, _hooks.useDatasetDetailsTelemetry)();
  const hostsLocator = observabilityShared.locators.infra.hostsLocator;
  const degradedDocsLinkProps = (0, _hooks.useRedirectLink)({
    dataStreamStat,
    query: {
      language: 'kuery',
      query: `${_es_fields._IGNORED}: *`
    },
    timeRangeConfig: timeRange,
    telemetry: {
      page: 'details',
      navigationSource: _telemetry.NavigationSource.Summary
    }
  });
  const kpis = (0, _react.useMemo)(() => (0, _get_summary_kpis.getSummaryKpis)({
    dataStreamDetails,
    timeRange,
    degradedDocsLinkProps,
    hostsLocator,
    telemetry
  }), [dataStreamDetails, degradedDocsLinkProps, hostsLocator, telemetry, timeRange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "m"
  }, kpis.map(kpi => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: kpi.title
  }, /*#__PURE__*/_react.default.createElement(_flyout_summary_kpi_item.FlyoutSummaryKpiItem, (0, _extends2.default)({}, kpi, {
    isLoading: isLoading
  }))))));
}
function FlyoutSummaryKpisLoading() {
  const telemetry = (0, _hooks.useDatasetDetailsTelemetry)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "m"
  }, (0, _get_summary_kpis.getSummaryKpis)({
    telemetry
  }).map(({
    title
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: title
  }, /*#__PURE__*/_react.default.createElement(_flyout_summary_kpi_item.FlyoutSummaryKpiItemLoading, {
    title: title
  })))));
}