"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutSummaryKpiItem = FlyoutSummaryKpiItem;
exports.FlyoutSummaryKpiItemLoading = FlyoutSummaryKpiItemLoading;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("../../common");
var _translations = require("../../../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FlyoutSummaryKpiItem({
  title,
  value,
  link,
  isLoading,
  userHasPrivilege
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": `datasetQualityFlyoutKpi-${title}${isLoading ? '--loading' : ''}`,
    css: {
      minWidth: 152,
      height: 130,
      display: 'flex',
      alignItems: 'stretch'
    },
    hasBorder: true,
    grow: false,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "stretch",
    direction: "column",
    wrap: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      gap: euiTheme.size.xs
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": `datasetQualityFlyoutKpiTitle-${title}`,
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h6", null, title)), /*#__PURE__*/_react.default.createElement(_common.PrivilegesWarningIconWrapper, {
    hasPrivileges: userHasPrivilege,
    title: title,
    mode: "popover",
    popoverCss: {
      marginLeft: 'auto'
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null))), link ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": `datasetQualityFlyoutKpiLink-${title}`,
    css: {
      display: 'flex',
      alignItems: 'center',
      width: 'fit-content'
    }
  }, link.props), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: {
      fontWeight: euiTheme.font.weight.semiBold,
      whiteSpace: 'nowrap'
    },
    size: "xs"
  }, link.label)) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      alignItems: isLoading ? 'stretch' : 'flex-end',
      justifyContent: 'flex-end'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
    style: {
      width: '50%',
      marginLeft: 'auto'
    },
    size: "m",
    isLoading: isLoading
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": `datasetQualityFlyoutKpiValue-${title}`,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    className: "eui-textNoWrap"
  }, userHasPrivilege ? value : _translations.notAvailableLabel))))));
}
function FlyoutSummaryKpiItemLoading({
  title
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    "data-test-subj": `datasetQualityFlyoutKpi-${title}--loading`,
    css: {
      minWidth: 152
    },
    width: '100%',
    height: 130
  });
}