"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutSummaryHeader = FlyoutSummaryHeader;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _translations = require("../../../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FlyoutSummaryHeader({
  timeRange,
  onTimeChange,
  onRefresh
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
          flex-grow: 1;
        `,
    justifyContent: "flexStart",
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("span", null, _translations.flyoutSummaryText)), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: flyoutSummaryTooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    color: "subdued",
    type: "questionInCircle",
    className: "eui-alignTop"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
          flex-grow: 0;
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    width: "auto",
    compressed: true,
    isLoading: false,
    start: timeRange.from,
    end: timeRange.to,
    onTimeChange: onTimeChange,
    onRefresh: onRefresh,
    isQuickSelectOnly: false,
    showUpdateButton: "iconOnly",
    updateButtonProps: {
      fill: false
    }
  })));
}
const flyoutSummaryTooltip = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.flyoutSummaryTooltip",
  defaultMessage: "Stats of the data set within the selected time range."
});