"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutSummary = FlyoutSummary;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _degraded_docs = require("../degraded_docs_trend/degraded_docs");
var _constants = require("../../../../common/constants");
var _context = require("../../dataset_quality/context");
var _flyout_summary_header = require("./flyout_summary_header");
var _flyout_summary_kpis = require("./flyout_summary_kpis");
var _degraded_fields = require("../degraded_fields/degraded_fields");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nonAggregatableWarningTitle = _i18n.i18n.translate('xpack.datasetQuality.nonAggregatable.title', {
  defaultMessage: 'Your request may take longer to complete'
});
const nonAggregatableWarningDescription = dataset => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.flyout.nonAggregatable.description",
  defaultMessage: "{description}",
  values: {
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.datasetQuality.flyout.nonAggregatable.warning",
      defaultMessage: "{dataset}does not support _ignored aggregation and may cause delays when querying data. {howToFixIt}",
      values: {
        dataset: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          language: "json",
          transparentBackground: true
        }, dataset),
        howToFixIt: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.datasetQuality.flyout.nonAggregatable.howToFixIt",
          defaultMessage: "Manually {rolloverLink} this data set to prevent future delays.",
          values: {
            rolloverLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
              external: true,
              target: "_blank",
              "data-test-subj": "datasetQualityFlyoutNonAggregatableHowToFixItLink",
              href: "https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-rollover-index.html"
            }, _i18n.i18n.translate('xpack.datasetQuality.flyout.nonAggregatableDatasets.link.title', {
              defaultMessage: 'rollover'
            }))
          }
        })
      }
    })
  }
});
function FlyoutSummary({
  dataStream,
  dataStreamStat,
  dataStreamDetails,
  isNonAggregatable,
  dataStreamDetailsLoading,
  timeRange = {
    ..._constants.DEFAULT_TIME_RANGE,
    refresh: _constants.DEFAULT_DATEPICKER_REFRESH
  }
}) {
  const {
    service
  } = (0, _context.useDatasetQualityContext)();
  const [lastReloadTime, setLastReloadTime] = (0, _react.useState)(Date.now());
  const updateTimeRange = (0, _react.useCallback)(({
    start,
    end,
    refreshInterval
  }) => {
    service.send({
      type: 'UPDATE_INSIGHTS_TIME_RANGE',
      timeRange: {
        from: start,
        to: end,
        refresh: {
          ..._constants.DEFAULT_DATEPICKER_REFRESH,
          value: refreshInterval
        }
      }
    });
  }, [service]);
  const handleTimeChange = (0, _react.useCallback)(({
    isInvalid,
    ...timeRangeProps
  }) => {
    if (!isInvalid) {
      updateTimeRange({
        refreshInterval: timeRange.refresh.value,
        ...timeRangeProps
      });
    }
  }, [updateTimeRange, timeRange.refresh]);
  const handleTimeRangeChange = (0, _react.useCallback)(({
    start,
    end
  }) => {
    updateTimeRange({
      start,
      end,
      refreshInterval: timeRange.refresh.value
    });
  }, [updateTimeRange, timeRange.refresh]);
  const handleRefresh = (0, _react.useCallback)(refreshProps => {
    updateTimeRange(refreshProps);
    setLastReloadTime(Date.now());
  }, [updateTimeRange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isNonAggregatable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "datasetQualityFlyoutNonAggregatableWarning",
    style: {
      marginBottom: '24px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: nonAggregatableWarningTitle,
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, nonAggregatableWarningDescription(dataStream))))), /*#__PURE__*/_react.default.createElement(_flyout_summary_header.FlyoutSummaryHeader, {
    timeRange: timeRange,
    onTimeChange: handleTimeChange,
    onRefresh: handleRefresh
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), dataStreamStat ? /*#__PURE__*/_react.default.createElement(_flyout_summary_kpis.FlyoutSummaryKpis, {
    dataStreamStat: dataStreamStat,
    dataStreamDetails: dataStreamDetails,
    isLoading: dataStreamDetailsLoading,
    timeRange: timeRange
  }) : /*#__PURE__*/_react.default.createElement(_flyout_summary_kpis.FlyoutSummaryKpisLoading, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_degraded_docs.DegradedDocs, {
    dataStream: dataStream,
    timeRange: timeRange,
    lastReloadTime: lastReloadTime,
    onTimeRangeChange: handleTimeRangeChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_degraded_fields.DegradedFields, null));
}