"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Flyout;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _translations = require("../../../common/translations");
var _hooks = require("../../hooks");
var _dataset_summary = require("./dataset_summary");
var _header = require("./header");
var _integration_summary = require("./integration_summary");
var _flyout_summary = require("./flyout_summary/flyout_summary");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function Flyout({
  dataset,
  closeFlyout
}) {
  const {
    dataStreamStat,
    dataStreamSettings,
    dataStreamDetails,
    isNonAggregatable,
    fieldFormats,
    timeRange,
    loadingState,
    flyoutLoading
  } = (0, _hooks.useDatasetQualityFlyout)();
  const {
    startTracking
  } = (0, _hooks.useDatasetDetailsTelemetry)();
  (0, _react.useEffect)(() => {
    startTracking();
  }, [startTracking]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout,
    ownFocus: true,
    "data-component-name": 'datasetQualityFlyout',
    "data-test-subj": "datasetQualityFlyout"
  }, flyoutLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    width: "100%",
    height: 80
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header.Header, {
    dataStreamStat: dataset
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: flyoutBodyStyles,
    "data-test-subj": "datasetQualityFlyoutBody"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_flyout_summary.FlyoutSummary, {
    dataStream: dataset.rawName,
    dataStreamStat: dataStreamStat,
    dataStreamDetails: dataStreamDetails,
    dataStreamDetailsLoading: loadingState.dataStreamDetailsLoading,
    timeRange: timeRange,
    isNonAggregatable: isNonAggregatable
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "l"
  }, loadingState.dataStreamDetailsLoading && loadingState.dataStreamSettingsLoading ? /*#__PURE__*/_react.default.createElement(_dataset_summary.DatasetSummaryLoading, null) : dataStreamStat ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_dataset_summary.DatasetSummary, {
    dataStreamSettings: dataStreamSettings,
    dataStreamSettingsLoading: loadingState.dataStreamSettingsLoading,
    dataStreamDetails: dataStreamDetails,
    dataStreamDetailsLoading: loadingState.dataStreamDetailsLoading,
    fieldFormats: fieldFormats
  }), dataStreamStat.integration && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_integration_summary.IntegrationSummary, {
    integration: dataStreamStat.integration,
    dashboardsLoading: loadingState.datasetIntegrationsLoading
  }))) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "datasetQualityFlyoutButton",
    iconType: "cross",
    onClick: closeFlyout,
    flush: "left"
  }, _translations.flyoutCancelText))))));
}
const flyoutBodyStyles = (0, _react2.css)`
  .euiFlyoutBody__overflowContent {
    padding: 0;
  }
`;
module.exports = exports.default;