"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDegradedFieldsColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _spark_plot = require("./spark_plot");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fieldColumnName = _i18n.i18n.translate('xpack.datasetQuality.flyout.degradedField.field', {
  defaultMessage: 'Field'
});
const countColumnName = _i18n.i18n.translate('xpack.datasetQuality.flyout.degradedField.count', {
  defaultMessage: 'Docs count'
});
const lastOccurrenceColumnName = _i18n.i18n.translate('xpack.datasetQuality.flyout.degradedField.lastOccurrence', {
  defaultMessage: 'Last occurrence'
});
const getDegradedFieldsColumns = ({
  dateFormatter,
  isLoading
}) => [{
  name: fieldColumnName,
  field: 'name'
}, {
  name: countColumnName,
  sortable: true,
  field: 'count',
  render: (_, {
    count,
    timeSeries
  }) => {
    const countValue = (0, _eui.formatNumber)(count, _constants.NUMBER_FORMAT);
    return /*#__PURE__*/_react.default.createElement(_spark_plot.SparkPlot, {
      series: timeSeries,
      valueLabel: countValue,
      isLoading: isLoading
    });
  }
}, {
  name: lastOccurrenceColumnName,
  sortable: true,
  field: 'lastOccurrence',
  render: lastOccurrence => {
    return dateFormatter.convert(lastOccurrence);
  }
}];
exports.getDegradedFieldsColumns = getDegradedFieldsColumns;