"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DegradedDocs = DegradedDocs;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-histogram-plugin/public");
var _hooks = require("../../../hooks");
var _constants = require("../../../../common/constants");
var _translations = require("../../../../common/translations");
var _degraded_docs_chart = require("./degraded_docs_chart");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DegradedDocs({
  dataStream,
  timeRange = {
    ..._constants.DEFAULT_TIME_RANGE,
    refresh: _constants.DEFAULT_DATEPICKER_REFRESH
  },
  lastReloadTime,
  onTimeRangeChange
}) {
  const {
    dataView,
    breakdown,
    ...chartProps
  } = (0, _hooks.useDegradedDocsChart)({
    dataStream
  });
  const [breakdownDataViewField, setBreakdownDataViewField] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    if (breakdown.dataViewField && breakdown.fieldSupportsBreakdown) {
      setBreakdownDataViewField(breakdown.dataViewField);
    } else {
      setBreakdownDataViewField(undefined);
    }
    if (breakdown.dataViewField && !breakdown.fieldSupportsBreakdown) {
      // TODO: If needed, notify user that the field is not breakable
    }
  }, [setBreakdownDataViewField, breakdown.dataViewField, breakdown.fieldSupportsBreakdown]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
            flex-direction: row;
            justify-content: flex-start;
            align-items: flex-start;
            gap: 4px;
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h6", null, _translations.flyoutDegradedDocsText)), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: degradedDocsTooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    color: "subdued",
    type: "questionInCircle",
    className: "eui-alignTop"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    width: 160,
    height: 32,
    isLoading: !dataView
  }, /*#__PURE__*/_react.default.createElement(_public.UnifiedBreakdownFieldSelector, {
    dataView: dataView,
    breakdown: {
      field: breakdownDataViewField
    },
    onBreakdownFieldChange: breakdown.onChange
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_degraded_docs_chart.DegradedDocsChart, (0, _extends2.default)({}, chartProps, {
    timeRange: timeRange,
    lastReloadTime: lastReloadTime,
    onTimeRangeChange: onTimeRangeChange
  })));
}
const degradedDocsTooltip = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.flyoutDegradedDocsTooltip",
  defaultMessage: "The percentage of degraded documents \u2014documents with the {ignoredProperty} property\u2014 in your data set.",
  values: {
    ignoredProperty: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      language: "json",
      transparentBackground: true
    }, "_ignored")
  }
});