"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetSummary = DatasetSummary;
exports.DatasetSummaryLoading = DatasetSummaryLoading;
var _react = _interopRequireDefault(require("react"));
var _fieldTypes = require("@kbn/field-types");
var _translations = require("../../../common/translations");
var _fields_list = require("./fields_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DatasetSummary({
  dataStreamSettings,
  dataStreamSettingsLoading,
  dataStreamDetails,
  dataStreamDetailsLoading,
  fieldFormats
}) {
  const dataFormatter = fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.DATE, [_fieldTypes.ES_FIELD_TYPES.DATE]);
  const formattedLastActivity = dataStreamDetails !== null && dataStreamDetails !== void 0 && dataStreamDetails.lastActivity ? dataFormatter.convert(dataStreamDetails === null || dataStreamDetails === void 0 ? void 0 : dataStreamDetails.lastActivity) : '-';
  const formattedCreatedOn = dataStreamSettings !== null && dataStreamSettings !== void 0 && dataStreamSettings.createdOn ? dataFormatter.convert(dataStreamSettings.createdOn) : '-';
  return /*#__PURE__*/_react.default.createElement(_fields_list.FieldsList, {
    title: _translations.flyoutDatasetDetailsText,
    fields: [{
      fieldTitle: _translations.flyoutDatasetLastActivityText,
      fieldValue: formattedLastActivity,
      isLoading: dataStreamDetailsLoading
    }, {
      fieldTitle: _translations.flyoutDatasetCreatedOnText,
      fieldValue: formattedCreatedOn,
      isLoading: dataStreamSettingsLoading
    }]
  });
}
function DatasetSummaryLoading() {
  return /*#__PURE__*/_react.default.createElement(_fields_list.FieldsListLoading, null);
}