"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDatasetQualityTableColumns = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _fieldTypes = require("@kbn/field-types");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _constants = require("../../../../common/constants");
var _data_stream_stat = require("../../../../common/data_streams_stats/data_stream_stat");
var _telemetry = require("../../../services/telemetry");
var _quality_indicator = require("../../quality_indicator");
var _common = require("../../common");
var _hooks = require("../../../hooks");
var _degraded_docs_percentage_link = require("./degraded_docs_percentage_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const expandDatasetAriaLabel = _i18n.i18n.translate('xpack.datasetQuality.expandLabel', {
  defaultMessage: 'Expand'
});
const collapseDatasetAriaLabel = _i18n.i18n.translate('xpack.datasetQuality.collapseLabel', {
  defaultMessage: 'Collapse'
});
const nameColumnName = _i18n.i18n.translate('xpack.datasetQuality.nameColumnName', {
  defaultMessage: 'Data Set Name'
});
const namespaceColumnName = _i18n.i18n.translate('xpack.datasetQuality.namespaceColumnName', {
  defaultMessage: 'Namespace'
});
const sizeColumnName = _i18n.i18n.translate('xpack.datasetQuality.sizeColumnName', {
  defaultMessage: 'Size'
});
const degradedDocsColumnName = _i18n.i18n.translate('xpack.datasetQuality.degradedDocsColumnName', {
  defaultMessage: 'Degraded Docs (%)'
});
const datasetQualityColumnName = _i18n.i18n.translate('xpack.datasetQuality.datasetQualityColumnName', {
  defaultMessage: 'Data Set Quality'
});
const lastActivityColumnName = _i18n.i18n.translate('xpack.datasetQuality.lastActivityColumnName', {
  defaultMessage: 'Last Activity'
});
const actionsColumnName = _i18n.i18n.translate('xpack.datasetQuality.actionsColumnName', {
  defaultMessage: 'Actions'
});
const openActionName = _i18n.i18n.translate('xpack.datasetQuality.openActionName', {
  defaultMessage: 'Open'
});
const inactiveDatasetActivityColumnDescription = _i18n.i18n.translate('xpack.datasetQuality.inactiveDatasetActivityColumnDescription', {
  defaultMessage: 'No activity in the selected timeframe'
});
const inactiveDatasetActivityColumnTooltip = _i18n.i18n.translate('xpack.datasetQuality.inactiveDatasetActivityColumnTooltip', {
  defaultMessage: 'Try expanding the time range above for more results'
});
const degradedDocsDescription = (quality, minimimPercentage, comparator = '') => _i18n.i18n.translate('xpack.datasetQuality.degradedDocsQualityDescription', {
  defaultMessage: '{quality} -{comparator} {minimimPercentage}%',
  values: {
    quality,
    minimimPercentage,
    comparator
  }
});
const degradedDocsColumnTooltip = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.degradedDocsColumnTooltip",
  defaultMessage: "The percentage of documents with the {ignoredProperty} property in your data set.",
  values: {
    ignoredProperty: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      language: "json",
      transparentBackground: true
    }, "_ignored")
  }
});
const datasetQualityColumnTooltip = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.datasetQualityColumnTooltip",
  defaultMessage: "Quality is based on the percentage of degraded docs in a data set. {visualQueue}",
  values: {
    visualQueue: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityIndicator, {
      quality: "poor",
      description: ` ${degradedDocsDescription('Poor', _constants.POOR_QUALITY_MINIMUM_PERCENTAGE, ' greater than')}`
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityIndicator, {
      quality: "degraded",
      description: ` ${degradedDocsDescription('Degraded', _constants.DEGRADED_QUALITY_MINIMUM_PERCENTAGE, ' greater than')}`
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityIndicator, {
      quality: "good",
      description: ` ${degradedDocsDescription('Good', _constants.DEGRADED_QUALITY_MINIMUM_PERCENTAGE)}`
    })))
  }
});
const getDatasetQualityTableColumns = ({
  fieldFormats,
  canUserMonitorDataset,
  canUserMonitorAnyDataStream,
  selectedDataset,
  openFlyout,
  loadingDataStreamStats,
  loadingDegradedStats,
  showFullDatasetNames,
  isSizeStatsAvailable,
  isActiveDataset
}) => {
  return [{
    name: '',
    render: dataStreamStat => {
      const isExpanded = dataStreamStat.rawName === (selectedDataset === null || selectedDataset === void 0 ? void 0 : selectedDataset.rawName);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": "datasetQualityExpandButton",
        size: "xs",
        color: "text",
        onClick: () => openFlyout(dataStreamStat),
        iconType: isExpanded ? 'minimize' : 'expand',
        title: !isExpanded ? expandDatasetAriaLabel : collapseDatasetAriaLabel,
        "aria-label": !isExpanded ? expandDatasetAriaLabel : collapseDatasetAriaLabel
      });
    },
    width: '40px',
    css: (0, _react2.css)`
        &.euiTableCellContent {
          padding: 0;
        }
      `
  }, {
    name: nameColumnName,
    field: 'title',
    sortable: true,
    render: (title, dataStreamStat) => {
      const {
        integration,
        name
      } = dataStreamStat;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_common.IntegrationIcon, {
        integration: integration
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, title), showFullDatasetNames && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("em", null, name)));
    }
  }, {
    name: namespaceColumnName,
    field: 'namespace',
    sortable: true,
    render: (_, dataStreamStat) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, dataStreamStat.namespace),
    width: '160px'
  }, ...(isSizeStatsAvailable && canUserMonitorDataset && canUserMonitorAnyDataStream ? [{
    name: sizeColumnName,
    field: 'sizeBytes',
    sortable: true,
    render: (_, dataStreamStat) => {
      var _dataStreamStat$userP, _dataStreamStat$userP2;
      return /*#__PURE__*/_react.default.createElement(_common.PrivilegesWarningIconWrapper, {
        title: `sizeBytes-${dataStreamStat.title}`,
        hasPrivileges: (_dataStreamStat$userP = (_dataStreamStat$userP2 = dataStreamStat.userPrivileges) === null || _dataStreamStat$userP2 === void 0 ? void 0 : _dataStreamStat$userP2.canMonitor) !== null && _dataStreamStat$userP !== void 0 ? _dataStreamStat$userP : true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
        width: "60px",
        height: "20px",
        borderRadius: "m",
        isLoading: loadingDataStreamStats || loadingDegradedStats
      }, (0, _eui.formatNumber)(_data_stream_stat.DataStreamStat.calculateFilteredSize(dataStreamStat), _constants.BYTE_NUMBER_FORMAT)));
    },
    width: '100px'
  }] : []), {
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: datasetQualityColumnTooltip
    }, /*#__PURE__*/_react.default.createElement("span", null, `${datasetQualityColumnName} `, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop"
    }))),
    field: 'degradedDocs.percentage',
    sortable: true,
    render: (_, dataStreamStat) => /*#__PURE__*/_react.default.createElement(_quality_indicator.DatasetQualityIndicator, {
      isLoading: loadingDegradedStats,
      dataStreamStat: dataStreamStat
    }),
    width: '140px'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: degradedDocsColumnTooltip
    }, /*#__PURE__*/_react.default.createElement("span", null, `${degradedDocsColumnName} `, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop"
    }))),
    field: 'degradedDocs.percentage',
    sortable: true,
    render: (_, dataStreamStat) => /*#__PURE__*/_react.default.createElement(_degraded_docs_percentage_link.DegradedDocsPercentageLink, {
      isLoading: loadingDegradedStats,
      dataStreamStat: dataStreamStat
    }),
    width: '140px'
  }, ...(canUserMonitorDataset && canUserMonitorAnyDataStream ? [{
    name: lastActivityColumnName,
    field: 'lastActivity',
    render: (timestamp, {
      userPrivileges,
      title
    }) => {
      var _userPrivileges$canMo;
      return /*#__PURE__*/_react.default.createElement(_common.PrivilegesWarningIconWrapper, {
        title: `lastActivity-${title}`,
        hasPrivileges: (_userPrivileges$canMo = userPrivileges === null || userPrivileges === void 0 ? void 0 : userPrivileges.canMonitor) !== null && _userPrivileges$canMo !== void 0 ? _userPrivileges$canMo : true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
        width: "200px",
        height: "20px",
        borderRadius: "m",
        isLoading: loadingDataStreamStats
      }, !isActiveDataset(timestamp) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, inactiveDatasetActivityColumnDescription), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: inactiveDatasetActivityColumnTooltip
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        tabIndex: 0,
        type: "iInCircle",
        size: "s"
      }))) : fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.DATE, [_fieldTypes.ES_FIELD_TYPES.DATE]).convert(timestamp)));
    },
    width: '300px',
    sortable: true
  }] : []), {
    name: actionsColumnName,
    render: dataStreamStat => /*#__PURE__*/_react.default.createElement(RedirectLink, {
      dataStreamStat: dataStreamStat,
      title: openActionName
    }),
    width: '100px'
  }];
};
exports.getDatasetQualityTableColumns = getDatasetQualityTableColumns;
const RedirectLink = ({
  dataStreamStat,
  title
}) => {
  const redirectLinkProps = (0, _hooks.useRedirectLink)({
    dataStreamStat,
    telemetry: {
      page: 'main',
      navigationSource: _telemetry.NavigationSource.Table
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": "datasetQualityLogsExplorerLinkLink"
  }, redirectLinkProps.linkProps), title);
};