"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = SummaryPanel;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _hooks = require("../../../hooks");
var _datasets_quality_indicators = require("./datasets_quality_indicators");
var _datasets_activity = require("./datasets_activity");
var _estimated_data = require("./estimated_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function SummaryPanel() {
  const {
    isEstimatedDataDisabled
  } = (0, _hooks.useSummaryPanelContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_datasets_quality_indicators.DatasetsQualityIndicators, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_datasets_activity.DatasetsActivity, null), !isEstimatedDataDisabled && /*#__PURE__*/_react.default.createElement(_estimated_data.EstimatedData, null))));
}
module.exports = exports.default;