"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegesWarningIconWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const insufficientPrivilegesText = _i18n.i18n.translate('xpack.datasetQuality.insufficientPrivilegesMessage', {
  defaultMessage: "You don't have sufficient privileges to access this information."
});

// @ts-ignore // TODO: Add link to Dataset Quality permissions documentation
const LearnMoreLink = () => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  "data-test-subj": "datasetQualityMissingPrivilegesLink",
  target: "_blank"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.insufficientPrivilegesLearnMore",
  defaultMessage: "Learn more"
}));
const PrivilegesWarningIconWrapper = ({
  hasPrivileges,
  title,
  mode = 'popover',
  iconColor = 'warning',
  popoverCss,
  children
}) => {
  const [isPopoverOpen, togglePopover] = (0, _useToggle.default)(false);
  const handleButtonClick = (0, _react.useCallback)(() => togglePopover(true), [togglePopover]);
  if (hasPrivileges) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }
  return mode === 'popover' ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    css: popoverCss,
    attachToAnchor: true,
    anchorPosition: "downCenter",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": `datasetQualityInsufficientPrivileges-${title}`,
      "aria-label": insufficientPrivilegesText,
      title: insufficientPrivilegesText,
      iconType: "warning",
      color: iconColor,
      onClick: handleButtonClick
    }),
    isOpen: isPopoverOpen,
    closePopover: togglePopover
  }, insufficientPrivilegesText, " ") : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: insufficientPrivilegesText
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    "data-test-subj": `datasetQualityInsufficientPrivileges-${title}`,
    "aria-label": insufficientPrivilegesText,
    title: insufficientPrivilegesText,
    type: "warning",
    color: iconColor
  }), children));
};
exports.PrivilegesWarningIconWrapper = PrivilegesWarningIconWrapper;