"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.streamPartsToIndexPattern = exports.indexNameToDataStreamParts = exports.extractIndexNameFromBackingIndex = exports.dataStreamPartsToIndexName = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const streamPartsToIndexPattern = ({
  typePattern,
  datasetPattern
}) => {
  return `${typePattern}-${datasetPattern}`;
};
exports.streamPartsToIndexPattern = streamPartsToIndexPattern;
const dataStreamPartsToIndexName = ({
  type,
  dataset,
  namespace
}) => {
  return `${type}-${dataset}-${namespace}`;
};
exports.dataStreamPartsToIndexName = dataStreamPartsToIndexName;
const indexNameToDataStreamParts = dataStreamName => {
  const [type, ...dataStreamParts] = dataStreamName.split('-');
  const namespace = dataStreamParts[dataStreamParts.length - 1];
  const dataset = dataStreamParts.slice(0, dataStreamParts.length - 1).join('-');
  return {
    type: type,
    dataset,
    namespace
  };
};
exports.indexNameToDataStreamParts = indexNameToDataStreamParts;
const extractIndexNameFromBackingIndex = indexString => {
  const pattern = /.ds-(.*?)-[0-9]{4}\.[0-9]{2}\.[0-9]{2}-[0-9]{6}/;
  const match = indexString.match(pattern);
  return match ? match[1] : indexString;
};
exports.extractIndexNameFromBackingIndex = extractIndexNameFromBackingIndex;