"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DegradedDocsStat = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DegradedDocsStat {
  constructor(degradedDocsStat) {
    (0, _defineProperty2.default)(this, "dataset", void 0);
    (0, _defineProperty2.default)(this, "percentage", void 0);
    (0, _defineProperty2.default)(this, "count", void 0);
    (0, _defineProperty2.default)(this, "docsCount", void 0);
    (0, _defineProperty2.default)(this, "quality", void 0);
    this.dataset = degradedDocsStat.dataset;
    this.percentage = degradedDocsStat.percentage;
    this.count = degradedDocsStat.count;
    this.docsCount = degradedDocsStat.docsCount;
    this.quality = degradedDocsStat.quality;
  }
  static create(degradedDocsStat) {
    const quality = (0, _utils.mapPercentageToQuality)(degradedDocsStat.percentage);
    return new DegradedDocsStat({
      ...degradedDocsStat,
      quality
    });
  }
}
exports.DegradedDocsStat = DegradedDocsStat;