"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamStat = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../constants");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataStreamStat {
  constructor(dataStreamStat) {
    var _dataStreamStat$title;
    (0, _defineProperty2.default)(this, "rawName", void 0);
    (0, _defineProperty2.default)(this, "type", void 0);
    (0, _defineProperty2.default)(this, "name", void 0);
    (0, _defineProperty2.default)(this, "namespace", void 0);
    (0, _defineProperty2.default)(this, "title", void 0);
    (0, _defineProperty2.default)(this, "size", void 0);
    // total datastream size
    (0, _defineProperty2.default)(this, "sizeBytes", void 0);
    // total datastream size
    (0, _defineProperty2.default)(this, "lastActivity", void 0);
    (0, _defineProperty2.default)(this, "userPrivileges", void 0);
    (0, _defineProperty2.default)(this, "totalDocs", void 0);
    // total datastream docs count
    (0, _defineProperty2.default)(this, "integration", void 0);
    (0, _defineProperty2.default)(this, "degradedDocs", void 0);
    this.rawName = dataStreamStat.rawName;
    this.type = dataStreamStat.type;
    this.name = dataStreamStat.name;
    this.title = (_dataStreamStat$title = dataStreamStat.title) !== null && _dataStreamStat$title !== void 0 ? _dataStreamStat$title : dataStreamStat.name;
    this.namespace = dataStreamStat.namespace;
    this.size = dataStreamStat.size;
    this.sizeBytes = dataStreamStat.sizeBytes;
    this.lastActivity = dataStreamStat.lastActivity;
    this.userPrivileges = dataStreamStat.userPrivileges;
    this.totalDocs = dataStreamStat.totalDocs;
    this.integration = dataStreamStat.integration;
    this.degradedDocs = {
      percentage: dataStreamStat.degradedDocs.percentage,
      count: dataStreamStat.degradedDocs.count,
      docsCount: dataStreamStat.degradedDocs.docsCount,
      quality: dataStreamStat.degradedDocs.quality
    };
  }
  static create(dataStreamStat) {
    const {
      type,
      dataset,
      namespace
    } = (0, _utils.indexNameToDataStreamParts)(dataStreamStat.name);
    const dataStreamStatProps = {
      rawName: dataStreamStat.name,
      type,
      name: dataset,
      title: dataset,
      namespace,
      size: dataStreamStat.size,
      sizeBytes: dataStreamStat.sizeBytes,
      lastActivity: dataStreamStat.lastActivity,
      userPrivileges: dataStreamStat.userPrivileges,
      totalDocs: dataStreamStat.totalDocs,
      degradedDocs: _constants.DEFAULT_DEGRADED_DOCS
    };
    return new DataStreamStat(dataStreamStatProps);
  }
  static fromDegradedDocStat({
    degradedDocStat,
    datasetIntegrationMap
  }) {
    var _datasetIntegrationMa, _datasetIntegrationMa2;
    const {
      type,
      dataset,
      namespace
    } = (0, _utils.indexNameToDataStreamParts)(degradedDocStat.dataset);
    const dataStreamStatProps = {
      rawName: degradedDocStat.dataset,
      type,
      name: dataset,
      title: ((_datasetIntegrationMa = datasetIntegrationMap[dataset]) === null || _datasetIntegrationMa === void 0 ? void 0 : _datasetIntegrationMa.title) || dataset,
      namespace,
      integration: (_datasetIntegrationMa2 = datasetIntegrationMap[dataset]) === null || _datasetIntegrationMa2 === void 0 ? void 0 : _datasetIntegrationMa2.integration,
      degradedDocs: {
        percentage: degradedDocStat.percentage,
        count: degradedDocStat.count,
        docsCount: degradedDocStat.docsCount,
        quality: (0, _utils.mapPercentageToQuality)(degradedDocStat.percentage)
      }
    };
    return new DataStreamStat(dataStreamStatProps);
  }
  static calculateFilteredSize({
    sizeBytes,
    totalDocs,
    degradedDocs
  }) {
    const avgDocSize = sizeBytes && totalDocs ? sizeBytes / totalDocs : 0;
    return avgDocSize * degradedDocs.docsCount;
  }
}
exports.DataStreamStat = DataStreamStat;