"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = routes;
var _configSchema = require("@kbn/config-schema");
var _error_wrapper = require("./utils/error_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @apiGroup DataVisualizer
 *
 * @api {post} /internal/data_visualizer/test_grok_pattern Tests a grok pattern against a sample of text
 * @apiName testGrokPattern
 * @apiDescription Tests a grok pattern against a sample of text and return the positions of the fields
 */
function routes(coreSetup, logger) {
  const router = coreSetup.http.createRouter();
  router.versioned.post({
    path: '/internal/data_visualizer/test_grok_pattern',
    access: 'internal',
    options: {
      tags: ['access:fileUpload:analyzeFile']
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: _configSchema.schema.object({
          grokPattern: _configSchema.schema.string(),
          text: _configSchema.schema.arrayOf(_configSchema.schema.string()),
          ecsCompatibility: _configSchema.schema.maybe(_configSchema.schema.string())
        })
      }
    }
  }, async (context, request, response) => {
    try {
      const esClient = (await context.core).elasticsearch.client;
      const body = await esClient.asInternalUser.transport.request({
        method: 'GET',
        path: `/_text_structure/test_grok_pattern`,
        body: {
          grok_pattern: request.body.grokPattern,
          text: request.body.text
        },
        ...(request.body.ecsCompatibility ? {
          querystring: {
            ecs_compatibility: request.body.ecsCompatibility
          }
        } : {})
      });
      return response.ok({
        body
      });
    } catch (e) {
      logger.warn(`Unable to test grok pattern ${e.message}`);
      return response.customError((0, _error_wrapper.wrapError)(e));
    }
  });
}