"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEsQueryFromSavedSearch = getEsQueryFromSavedSearch;
exports.getQueryFromSavedSearchObject = getQueryFromSavedSearchObject;
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
var _common = require("@kbn/data-plugin/common");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _types = require("../../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO Consolidate with duplicate component `CorrelationsProgressControls` in
// `x-pack/plugins/observability_solution/apm/public/components/app/correlations/progress_controls.tsx`

/**
 * Parse the stringified searchSourceJSON
 * from a saved search or saved search object
 */
function getQueryFromSavedSearchObject(savedSearch) {
  var _savedSearch$attribut, _savedSearch$attribut2;
  if (!(0, _types.isSavedSearchSavedObject)(savedSearch)) {
    return savedSearch.searchSource.getSerializedFields();
  }
  const search = (_savedSearch$attribut = savedSearch === null || savedSearch === void 0 ? void 0 : (_savedSearch$attribut2 = savedSearch.attributes) === null || _savedSearch$attribut2 === void 0 ? void 0 : _savedSearch$attribut2.kibanaSavedObjectMeta) !== null && _savedSearch$attribut !== void 0 ? _savedSearch$attribut : // @ts-ignore
  savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.kibanaSavedObjectMeta;
  const parsed = typeof (search === null || search === void 0 ? void 0 : search.searchSourceJSON) === 'string' ? JSON.parse(search.searchSourceJSON) : undefined;

  // Remove indexRefName because saved search might no longer be relevant
  // if user modifies the query or filter
  // after opening a saved search
  if (parsed && Array.isArray(parsed.filter)) {
    parsed.filter.forEach(f => {
      // @ts-expect-error indexRefName does appear in meta for newly created saved search
      f.meta.indexRefName = undefined;
    });
  }
  return parsed;
}
function getSavedSearchSource(savedSearch) {
  return (0, _mlIsDefined.isDefined)(savedSearch) && 'searchSource' in savedSearch && (savedSearch === null || savedSearch === void 0 ? void 0 : savedSearch.searchSource) instanceof _common.SearchSource ? savedSearch.searchSource : undefined;
}
function isNonAggregateQuery(query) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(query, ['query', 'language']);
}

/**
 * Extract query data from the saved search object
 * with overrides from the provided query data and/or filters
 */
function getEsQueryFromSavedSearch({
  dataView,
  uiSettings,
  savedSearch,
  query,
  filters,
  filterManager
}) {
  var _filterManager$getGlo;
  if (!dataView && !savedSearch) return;

  // Cannot support AggregateQuery (esql or sql) here
  if (query && !isNonAggregateQuery(query)) return;
  const userQuery = query;
  const userFilters = filters;
  const savedSearchSource = getSavedSearchSource(savedSearch);

  // If saved search has a search source with nested parent
  // e.g. a search coming from Dashboard saved search embeddable
  // which already combines both the saved search's original query/filters and the Dashboard's
  // then no need to process any further
  if (savedSearchSource && savedSearchSource.getParent() !== undefined && userQuery) {
    var _cloneDeep, _savedSearchSource$ge, _savedSearchSource$ge2;
    // Flattened query from search source may contain a clause that narrows the time range
    // which might interfere with global time pickers so we need to remove
    const savedQuery = (_cloneDeep = (0, _lodash.cloneDeep)((_savedSearchSource$ge = savedSearchSource.getSearchRequestBody()) === null || _savedSearchSource$ge === void 0 ? void 0 : _savedSearchSource$ge.query)) !== null && _cloneDeep !== void 0 ? _cloneDeep : (0, _mlQueryUtils.getDefaultDSLQuery)();
    const timeField = (_savedSearchSource$ge2 = savedSearchSource.getField('index')) === null || _savedSearchSource$ge2 === void 0 ? void 0 : _savedSearchSource$ge2.timeFieldName;
    if (Array.isArray(savedQuery.bool.filter) && timeField !== undefined) {
      savedQuery.bool.filter = savedQuery.bool.filter.filter(c => {
        var _c$range;
        return !(c.hasOwnProperty('range') && (_c$range = c.range) !== null && _c$range !== void 0 && _c$range.hasOwnProperty(timeField));
      });
    }
    return {
      searchQuery: savedQuery,
      searchString: userQuery.query,
      queryLanguage: userQuery.language
    };
  }

  // If no saved search available, use user's query and filters
  if (!savedSearch && (userQuery || userFilters || filterManager && ((_filterManager$getGlo = filterManager.getGlobalFilters()) === null || _filterManager$getGlo === void 0 ? void 0 : _filterManager$getGlo.length) > 0)) {
    var _filterManager$getFil, _userQuery$query, _userQuery$language;
    const combinedQuery = (0, _esQuery.buildEsQuery)(dataView, userQuery !== null && userQuery !== void 0 ? userQuery : [], [...((_filterManager$getFil = filterManager === null || filterManager === void 0 ? void 0 : filterManager.getFilters()) !== null && _filterManager$getFil !== void 0 ? _filterManager$getFil : []), ...(userFilters !== null && userFilters !== void 0 ? userFilters : [])], uiSettings ? (0, _common.getEsQueryConfig)(uiSettings) : undefined);
    return {
      searchQuery: combinedQuery,
      searchString: (_userQuery$query = userQuery === null || userQuery === void 0 ? void 0 : userQuery.query) !== null && _userQuery$query !== void 0 ? _userQuery$query : '',
      queryLanguage: (_userQuery$language = userQuery === null || userQuery === void 0 ? void 0 : userQuery.language) !== null && _userQuery$language !== void 0 ? _userQuery$language : 'kuery'
    };
  }

  // If saved search available, merge saved search with the latest user query or filters
  // which might differ from extracted saved search data
  if (savedSearchSource) {
    var _filterManager$getFil2, _currentQuery$query, _ref;
    const currentQuery = userQuery !== null && userQuery !== void 0 ? userQuery : savedSearchSource.getField('query');
    if (savedSearchSource.getField('filter')) {
      // Rehydrate filter from saved search object into filter manager's store
      if (filterManager) {
        filterManager.addFilters(savedSearchSource.getField('filter'));
      }
    }
    const combinedQuery = (0, _esQuery.buildEsQuery)(dataView, currentQuery, [...((_filterManager$getFil2 = filterManager === null || filterManager === void 0 ? void 0 : filterManager.getFilters()) !== null && _filterManager$getFil2 !== void 0 ? _filterManager$getFil2 : []), ...(userFilters !== null && userFilters !== void 0 ? userFilters : [])], uiSettings ? (0, _common.getEsQueryConfig)(uiSettings) : undefined);
    return {
      searchQuery: combinedQuery,
      searchString: (_currentQuery$query = currentQuery === null || currentQuery === void 0 ? void 0 : currentQuery.query) !== null && _currentQuery$query !== void 0 ? _currentQuery$query : '',
      queryLanguage: (_ref = currentQuery === null || currentQuery === void 0 ? void 0 : currentQuery.language) !== null && _ref !== void 0 ? _ref : 'kuery',
      queryOrAggregateQuery: currentQuery
    };
  }
}