"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAddFieldStatsTableAction = createAddFieldStatsTableAction;
var _i18n = require("@kbn/i18n");
var _presentationContainers = require("@kbn/presentation-containers");
var _public = require("@kbn/ui-actions-plugin/public");
var _esqlUtils = require("@kbn/esql-utils");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _mlIsDefined = require("@kbn/ml-is-defined");
var _public3 = require("@kbn/visualizations-plugin/public");
var _constants = require("../embeddables/field_stats/constants");
var _types = require("../embeddables/grid_embeddable/types");
var _get_data_view_by_index_pattern = require("../search_strategy/requests/get_data_view_by_index_pattern");
var _field_stats_initializer = require("../embeddables/field_stats/field_stats_initializer");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const parentApiIsCompatible = async parentApi => {
  const {
    apiIsPresentationContainer
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/presentation-containers')));
  // we cannot have an async type check, so return the casted parentApi rather than a boolean
  return apiIsPresentationContainer(parentApi) ? parentApi : undefined;
};
async function updatePanelFromFlyoutEdits({
  api,
  isNewPanel,
  deletePanel,
  coreStart,
  pluginStart,
  initialState
}) {
  const parentApi = api.parentApi;
  const overlayTracker = (0, _presentationContainers.tracksOverlays)(parentApi) ? parentApi : undefined;
  const services = {
    ...coreStart,
    ...pluginStart
  };
  let hasChanged = false;
  const cancelChanges = () => {
    // Reset to initialState in case user has changed the preview state
    if (hasChanged && api && initialState) {
      api.updateUserInput(initialState);
    }
    if (isNewPanel && deletePanel) {
      deletePanel();
    }
    flyoutSession.close();
    overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
  };
  const update = async nextUpdate => {
    var _nextUpdate$query;
    const esqlQuery = nextUpdate === null || nextUpdate === void 0 ? void 0 : (_nextUpdate$query = nextUpdate.query) === null || _nextUpdate$query === void 0 ? void 0 : _nextUpdate$query.esql;
    if ((0, _mlIsDefined.isDefined)(esqlQuery)) {
      const indexPatternFromQuery = (0, _esqlUtils.getIndexPatternFromESQLQuery)(esqlQuery);
      const dv = await (0, _get_data_view_by_index_pattern.getOrCreateDataViewByIndexPattern)(pluginStart.data.dataViews, indexPatternFromQuery, undefined);
      if (dv !== null && dv !== void 0 && dv.id && nextUpdate.dataViewId !== dv.id) {
        nextUpdate.dataViewId = dv.id;
      }
    }
    if (api) {
      api.updateUserInput(nextUpdate);
    }
    flyoutSession.close();
    overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
  };
  const flyoutSession = services.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_field_stats_initializer.FieldStatisticsInitializer, {
    initialInput: initialState,
    onPreview: async nextUpdate => {
      if (api.updateUserInput) {
        api.updateUserInput(nextUpdate);
        hasChanged = true;
      }
    },
    onCreate: update,
    onCancel: cancelChanges,
    isNewPanel: isNewPanel
  })), coreStart), {
    ownFocus: true,
    size: 's',
    paddingSize: 'm',
    hideCloseButton: true,
    type: 'push',
    'data-test-subj': 'fieldStatisticsInitializerFlyout',
    onClose: cancelChanges
  });
  overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.openOverlay(flyoutSession, {
    focusedPanelId: api.uuid
  });
}
function createAddFieldStatsTableAction(coreStart, pluginStart) {
  return {
    id: 'create-field-stats-table',
    grouping: _public3.COMMON_VISUALIZATION_GROUPING,
    order: 10,
    getIconType: () => 'inspect',
    getDisplayName: () => _i18n.i18n.translate('xpack.dataVisualizer.fieldStatistics.displayName', {
      defaultMessage: 'Field statistics'
    }),
    async isCompatible(context) {
      return Boolean(await parentApiIsCompatible(context.embeddable));
    },
    async execute(context) {
      const presentationContainerParent = await parentApiIsCompatible(context.embeddable);
      if (!presentationContainerParent) throw new _public.IncompatibleActionError();
      try {
        const defaultIndexPattern = await pluginStart.data.dataViews.getDefault();
        const defaultInitialState = {
          viewType: _types.FieldStatsInitializerViewType.ESQL,
          query: {
            // Initial default query
            esql: `from ${defaultIndexPattern === null || defaultIndexPattern === void 0 ? void 0 : defaultIndexPattern.getIndexPattern()} | limit 10`
          }
        };
        const embeddable = await presentationContainerParent.addNewPanel({
          panelType: _constants.FIELD_STATS_EMBEDDABLE_TYPE,
          initialState: defaultInitialState
        });
        // open the flyout if embeddable has been created successfully
        if (embeddable) {
          const deletePanel = () => {
            presentationContainerParent.removePanel(embeddable.uuid);
          };
          updatePanelFromFlyoutEdits({
            api: embeddable,
            isNewPanel: true,
            deletePanel,
            coreStart,
            pluginStart,
            initialState: defaultInitialState
          });
        }
      } catch (e) {
        return Promise.reject(e);
      }
    }
  };
}