"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getESQLDateFieldStats = void 0;
var _common = require("@kbn/data-plugin/common");
var _esqlUtils = require("@kbn/esql-utils");
var _esql_utils = require("../requests/esql_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getESQLDateFieldStats = async ({
  runRequest,
  columns,
  esqlBaseQuery,
  filter
}) => {
  const dateFields = columns.map(field => {
    return {
      field,
      query: `${(0, _esql_utils.getSafeESQLName)(`${field.name}_earliest`)} = MIN(${(0, _esql_utils.getSafeESQLName)(field.name)}), ${(0, _esql_utils.getSafeESQLName)(`${field.name}_latest`)} = MAX(${(0, _esql_utils.getSafeESQLName)(field.name)})`
    };
  });
  if (dateFields.length > 0) {
    const dateStatsQuery = ' | STATS ' + dateFields.map(({
      query
    }) => query).join(',');
    const query = (0, _esqlUtils.appendToESQLQuery)(esqlBaseQuery, dateStatsQuery);
    const request = {
      params: {
        query,
        ...(filter ? {
          filter
        } : {})
      }
    };
    try {
      const dateFieldsResp = await runRequest(request, {
        strategy: _common.ESQL_ASYNC_SEARCH_STRATEGY
      });
      if (dateFieldsResp) {
        return dateFields.map(({
          field: dateField
        }, idx) => {
          const row = dateFieldsResp.rawResponse.values[0];
          const earliest = row[idx * 2];
          const latest = row[idx * 2 + 1];
          return {
            fieldName: dateField.name,
            earliest,
            latest
          };
        });
      }
    } catch (error) {
      // Log for debugging purposes
      // eslint-disable-next-line no-console
      console.error(error, request);
      return dateFields.map(({
        field
      }, idx) => {
        return {
          fieldName: field.name,
          error
        };
      });
    }
  }
  return [];
};
exports.getESQLDateFieldStats = getESQLDateFieldStats;