"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public = require("@kbn/kibana-react-plugin/public");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _common = require("@kbn/data-plugin/common");
var _lodash = require("lodash");
var _kibana_services = require("../../../../kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EmbeddableESQLFieldStatsTableWrapper = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable_esql_field_stats_table'))));
const EmbeddableFieldStatsTableWrapper = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable_field_stats_table'))));
function isESQLFieldStatisticTableEmbeddableState(input) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(input, ['isEsqlMode']) && input.isEsqlMode === true;
}
function isFieldStatisticTableEmbeddableState(input) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(input, ['dataView']) && Boolean(input.isEsqlMode) === false;
}
const FieldStatisticsWrapperContent = props => {
  if (isESQLFieldStatisticTableEmbeddableState(props)) {
    var _props$isEsqlMode;
    return /*#__PURE__*/_react.default.createElement(EmbeddableESQLFieldStatsTableWrapper, {
      id: props.id,
      dataView: props.dataView,
      esqlQuery: props.esqlQuery,
      isEsqlMode: (_props$isEsqlMode = props.isEsqlMode) !== null && _props$isEsqlMode !== void 0 ? _props$isEsqlMode : props.esql,
      filters: props.filters,
      lastReloadRequestTime: props.lastReloadRequestTime,
      onAddFilter: props.onAddFilter,
      onTableUpdate: props.onTableUpdate,
      query: props.query,
      samplingOption: props.samplingOption,
      savedSearch: props.savedSearch,
      sessionId: props.sessionId,
      shouldGetSubfields: props.shouldGetSubfields,
      showPreviewByDefault: props.showPreviewByDefault,
      totalDocuments: props.totalDocuments,
      timeRange: props.timeRange,
      visibleFieldNames: props.visibleFieldNames,
      resetData$: props.resetData$,
      onRenderComplete: props.onRenderComplete
    });
  }
  if (isFieldStatisticTableEmbeddableState(props)) {
    return /*#__PURE__*/_react.default.createElement(EmbeddableFieldStatsTableWrapper, {
      id: props.id,
      dataView: props.dataView,
      isEsqlMode: false,
      filters: props.filters,
      lastReloadRequestTime: props.lastReloadRequestTime,
      onAddFilter: props.onAddFilter,
      onTableUpdate: props.onTableUpdate,
      query: props.query,
      samplingOption: props.samplingOption,
      savedSearch: props.savedSearch,
      sessionId: props.sessionId,
      shouldGetSubfields: props.shouldGetSubfields,
      showPreviewByDefault: props.showPreviewByDefault,
      totalDocuments: props.totalDocuments,
      timeRange: props.timeRange,
      visibleFieldNames: props.visibleFieldNames,
      resetData$: props.resetData$,
      onRenderComplete: props.onRenderComplete
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      iconColor: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.index.embeddableErrorTitle",
        defaultMessage: "Error loading embeddable"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.index.embeddableErrorDescription",
        defaultMessage: "There was an error loading the embeddable. Please check if all the required input is valid."
      }))
    });
  }
};
const FieldStatisticsWrapper = props => {
  var _props$isEsqlMode2;
  const coreStart = (0, _kibana_services.getCoreStart)();
  const {
    data,
    maps,
    embeddable,
    share,
    fileUpload,
    lens,
    dataViewFieldEditor,
    uiActions,
    charts,
    unifiedSearch
  } = (0, _kibana_services.getPluginsStart)();
  const services = {
    ...coreStart,
    data,
    maps,
    embeddable,
    share,
    fileUpload,
    lens,
    dataViewFieldEditor,
    uiActions,
    charts,
    unifiedSearch
  };
  const {
    overridableServices
  } = props;
  const kibanaRenderServices = (0, _react.useMemo)(() => (0, _lodash.pick)(coreStart, 'analytics', 'i18n', 'theme'),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const servicesWithOverrides = (0, _react.useMemo)(() => ({
    ...services,
    ...(overridableServices !== null && overridableServices !== void 0 ? overridableServices : {})
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const datePickerDeps = (0, _react.useMemo)(() => ({
    ...(0, _lodash.pick)(servicesWithOverrides, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'i18n']),
    uiSettingsKeys: _common.UI_SETTINGS
  }), [servicesWithOverrides]);
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, kibanaRenderServices, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: servicesWithOverrides
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, datePickerDeps, /*#__PURE__*/_react.default.createElement(FieldStatisticsWrapperContent, {
    id: props.id,
    dataView: props.dataView,
    isEsqlMode: (_props$isEsqlMode2 = props.isEsqlMode) !== null && _props$isEsqlMode2 !== void 0 ? _props$isEsqlMode2 : props.esql,
    esqlQuery: props.esqlQuery,
    filters: props.filters,
    lastReloadRequestTime: props.lastReloadRequestTime,
    onAddFilter: props.onAddFilter,
    onTableUpdate: props.onTableUpdate,
    query: props.query,
    samplingOption: props.samplingOption,
    savedSearch: props.savedSearch,
    sessionId: props.sessionId,
    shouldGetSubfields: props.shouldGetSubfields,
    showPreviewByDefault: props.showPreviewByDefault,
    totalDocuments: props.totalDocuments,
    visibleFieldNames: props.visibleFieldNames,
    resetData$: props.resetData$,
    timeRange: props.timeRange,
    onRenderComplete: props.onRenderComplete
  }))));
};
// exporting as default so it can be used with React.lazy
// eslint-disable-next-line import/no-default-export
var _default = exports.default = FieldStatisticsWrapper;
module.exports = exports.default;