"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveEmbeddableFieldStatsUserInput = resolveEmbeddableFieldStatsUserInput;
var _presentationContainers = require("@kbn/presentation-containers");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _esqlUtils = require("@kbn/esql-utils");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _field_stats_initializer = require("./field_stats_initializer");
var _get_data_view_by_index_pattern = require("../../search_strategy/requests/get_data_view_by_index_pattern");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function resolveEmbeddableFieldStatsUserInput(coreStart, pluginStart, parentApi, focusedPanelId, isNewPanel, initialState, fieldStatsControlsApi) {
  const {
    overlays
  } = coreStart;
  const overlayTracker = (0, _presentationContainers.tracksOverlays)(parentApi) ? parentApi : undefined;
  const services = {
    ...coreStart,
    ...pluginStart
  };
  let hasChanged = false;
  return new Promise(async (resolve, reject) => {
    try {
      const cancelChanges = () => {
        // Reset to initialState in case user has changed the preview state
        if (hasChanged && fieldStatsControlsApi && initialState) {
          fieldStatsControlsApi.updateUserInput(initialState);
        }
        flyoutSession.close();
        overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
      };
      const update = async nextUpdate => {
        var _nextUpdate$query;
        const esqlQuery = nextUpdate === null || nextUpdate === void 0 ? void 0 : (_nextUpdate$query = nextUpdate.query) === null || _nextUpdate$query === void 0 ? void 0 : _nextUpdate$query.esql;
        if ((0, _mlIsDefined.isDefined)(esqlQuery)) {
          const indexPatternFromQuery = (0, _esqlUtils.getIndexPatternFromESQLQuery)(esqlQuery);
          const dv = await (0, _get_data_view_by_index_pattern.getOrCreateDataViewByIndexPattern)(pluginStart.data.dataViews, indexPatternFromQuery, undefined);
          if (dv !== null && dv !== void 0 && dv.id && nextUpdate.dataViewId !== dv.id) {
            nextUpdate.dataViewId = dv.id;
          }
        }
        resolve(nextUpdate);
        flyoutSession.close();
        overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
      };
      const flyoutSession = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
        services: services
      }, /*#__PURE__*/_react.default.createElement(_field_stats_initializer.FieldStatisticsInitializer, {
        initialInput: initialState,
        onPreview: async nextUpdate => {
          if (fieldStatsControlsApi) {
            fieldStatsControlsApi.updateUserInput(nextUpdate);
            hasChanged = true;
          }
        },
        onCreate: update,
        onCancel: cancelChanges,
        isNewPanel: isNewPanel
      })), coreStart), {
        ownFocus: true,
        size: 's',
        paddingSize: 'm',
        hideCloseButton: true,
        type: 'push',
        'data-test-subj': 'fieldStatisticsInitializerFlyout',
        onClose: cancelChanges
      });
      if ((0, _presentationContainers.tracksOverlays)(parentApi)) {
        parentApi.openOverlay(flyoutSession, {
          focusedPanelId
        });
      }
    } catch (error) {
      reject(error);
    }
  });
}