"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldStatsChartEmbeddableFactory = exports.getDependencies = void 0;
var _public = require("@kbn/data-plugin/public");
var _common = require("@kbn/data-views-plugin/common");
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _esQuery = require("@kbn/es-query");
var _esqlUtils = require("@kbn/esql-utils");
var _public2 = require("@kbn/unified-search-plugin/public");
var _types = require("../grid_embeddable/types");
var _constants = require("./constants");
var _initialize_field_stats_controls = require("./initialize_field_stats_controls");
var _esql_utils = require("../../search_strategy/requests/esql_utils");
var _field_stats_component_type = require("../../constants/field_stats_component_type");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FieldStatisticsWrapper = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../grid_embeddable/field_stats_wrapper'))));
const ERROR_MSG = {
  APPLY_FILTER_ERR: _i18n.i18n.translate('xpack.dataVisualizer.fieldStats.errors.errorApplyingFilter', {
    defaultMessage: 'Error applying filter'
  }),
  UPDATE_CONFIG_ERROR: _i18n.i18n.translate('xpack.dataVisualizer.fieldStats.errors.errorUpdatingConfig', {
    defaultMessage: 'Error updating settings for field statistics.'
  })
};
const getDependencies = async getStartServices => {
  const [{
    http,
    uiSettings,
    notifications,
    ...startServices
  }, {
    lens,
    data,
    usageCollection,
    fieldFormats
  }] = await getStartServices();
  return {
    http,
    uiSettings,
    data,
    notifications,
    lens,
    usageCollection,
    fieldFormats,
    ...startServices
  };
};
exports.getDependencies = getDependencies;
const getFieldStatsChartEmbeddableFactory = getStartServices => {
  const factory = {
    type: _constants.FIELD_STATS_EMBEDDABLE_TYPE,
    deserializeState: state => {
      var _state$references;
      const serializedState = (0, _lodash.cloneDeep)(state.rawState);
      // inject the reference
      const dataViewIdRef = (_state$references = state.references) === null || _state$references === void 0 ? void 0 : _state$references.find(ref => ref.name === _constants.FIELD_STATS_DATA_VIEW_REF_NAME);
      // if the serializedState already contains a dataViewId, we don't want to overwrite it. (Unsaved state can cause this)
      if (dataViewIdRef && serializedState && !serializedState.dataViewId) {
        serializedState.dataViewId = dataViewIdRef === null || dataViewIdRef === void 0 ? void 0 : dataViewIdRef.id;
      }
      return serializedState;
    },
    buildEmbeddable: async (state, buildApi, uuid, parentApi) => {
      const [coreStart, pluginStart] = await getStartServices();
      const {
        http,
        uiSettings,
        notifications,
        ...startServices
      } = coreStart;
      const {
        lens,
        data,
        usageCollection,
        fieldFormats
      } = pluginStart;
      const deps = {
        http,
        uiSettings,
        data,
        notifications,
        lens,
        usageCollection,
        fieldFormats,
        ...startServices
      };
      const {
        api: timeRangeApi,
        comparators: timeRangeComparators,
        serialize: serializeTimeRange
      } = (0, _presentationPublishing.initializeTimeRange)(state);
      const {
        titlesApi,
        titleComparators,
        serializeTitles
      } = (0, _presentationPublishing.initializeTitles)(state);
      const {
        fieldStatsControlsApi,
        dataLoadingApi,
        fieldStatsControlsComparators,
        serializeFieldStatsChartState,
        onFieldStatsTableDestroy,
        resetData$
      } = (0, _initialize_field_stats_controls.initializeFieldStatsControls)(state);
      const {
        onError,
        dataLoading,
        blockingError
      } = dataLoadingApi;
      const defaultDataViewId = await deps.data.dataViews.getDefaultId();
      const validDataViewId = (0, _mlIsDefined.isDefined)(state.dataViewId) && state.dataViewId !== '' ? state.dataViewId : defaultDataViewId !== null && defaultDataViewId !== void 0 ? defaultDataViewId : '';
      let initialDataView;
      try {
        const dataView = (0, _esql_utils.isESQLQuery)(state.query) ? await (0, _esqlUtils.getESQLAdHocDataview)((0, _esqlUtils.getIndexPatternFromESQLQuery)(state.query.esql), deps.data.dataViews) : await deps.data.dataViews.get(validDataViewId);
        initialDataView = [dataView];
      } catch (error) {
        // Only need to publish blocking error if viewtype is data view, and no data view found
        if (state.viewType === _types.FieldStatsInitializerViewType.DATA_VIEW) {
          onError(error);
        }
      }
      const dataViews$ = new _rxjs.BehaviorSubject(initialDataView);
      const subscriptions = new _rxjs.Subscription();
      if (fieldStatsControlsApi.dataViewId$) {
        subscriptions.add(fieldStatsControlsApi.dataViewId$.pipe((0, _rxjs.skip)(1), (0, _rxjs.skipWhile)(dataViewId => !dataViewId && !defaultDataViewId), (0, _rxjs.switchMap)(async dataViewId => {
          try {
            return await deps.data.dataViews.get(dataViewId !== null && dataViewId !== void 0 ? dataViewId : defaultDataViewId);
          } catch (error) {
            return undefined;
          }
        })).subscribe(nextSelectedDataView => {
          if (nextSelectedDataView) {
            dataViews$.next([nextSelectedDataView]);
          }
        }));
      }
      const {
        toasts
      } = deps.notifications;
      const api = buildApi({
        ...timeRangeApi,
        ...titlesApi,
        ...fieldStatsControlsApi,
        // PublishesDataLoading
        dataLoading,
        // PublishesBlockingError
        blockingError,
        getTypeDisplayName: () => _i18n.i18n.translate('xpack.dataVisualizer.fieldStats.typeDisplayName', {
          defaultMessage: 'field statistics'
        }),
        isEditingEnabled: () => true,
        onEdit: async () => {
          try {
            const {
              resolveEmbeddableFieldStatsUserInput
            } = await Promise.resolve().then(() => _interopRequireWildcard(require('./resolve_field_stats_embeddable_input')));
            const chartState = serializeFieldStatsChartState();
            const nextUpdate = await resolveEmbeddableFieldStatsUserInput(coreStart, pluginStart, parentApi, uuid, false, chartState, fieldStatsControlsApi);
            fieldStatsControlsApi.updateUserInput(nextUpdate);
          } catch (e) {
            toasts.addError(e, {
              title: ERROR_MSG.UPDATE_CONFIG_ERROR
            });
          }
        },
        dataViews: dataViews$,
        serializeState: () => {
          var _fieldStatsControlsAp;
          const dataViewId = (_fieldStatsControlsAp = fieldStatsControlsApi.dataViewId$) === null || _fieldStatsControlsAp === void 0 ? void 0 : _fieldStatsControlsAp.getValue();
          const references = dataViewId ? [{
            type: _common.DATA_VIEW_SAVED_OBJECT_TYPE,
            name: _constants.FIELD_STATS_DATA_VIEW_REF_NAME,
            id: dataViewId
          }] : [];
          return {
            rawState: {
              ...serializeTitles(),
              ...serializeTimeRange(),
              ...serializeFieldStatsChartState()
            },
            references
          };
        }
      }, {
        ...timeRangeComparators,
        ...titleComparators,
        ...fieldStatsControlsComparators
      });
      const reload$ = (0, _presentationPublishing.fetch$)(api).pipe((0, _rxjs.skipWhile)(fetchContext => !fetchContext.isReload), (0, _rxjs.map)(() => Date.now()));
      const reset$ = resetData$.pipe((0, _rxjs.skip)(1), (0, _rxjs.distinctUntilChanged)());
      const onTableUpdate = changes => {
        if ((0, _mlIsDefined.isDefined)(changes === null || changes === void 0 ? void 0 : changes.showDistributions)) {
          fieldStatsControlsApi.showDistributions$.next(changes.showDistributions);
        }
      };
      const addFilters = (filters, actionId = _public2.ACTION_GLOBAL_APPLY_FILTER) => {
        if (!pluginStart.uiActions) {
          toasts.addWarning(ERROR_MSG.APPLY_FILTER_ERR);
          return;
        }
        const trigger = pluginStart.uiActions.getTrigger(_public.APPLY_FILTER_TRIGGER);
        if (!trigger) {
          toasts.addWarning(ERROR_MSG.APPLY_FILTER_ERR);
          return;
        }
        const actionContext = {
          embeddable: api,
          trigger
        };
        const executeContext = {
          ...actionContext,
          filters
        };
        try {
          const action = pluginStart.uiActions.getAction(actionId);
          action.execute(executeContext);
        } catch (error) {
          toasts.addWarning(ERROR_MSG.APPLY_FILTER_ERR);
        }
      };
      const statsTableCss = (0, _react2.css)({
        width: '100%',
        height: '100%',
        overflowY: 'auto'
      });
      return {
        api,
        Component: () => {
          if (!(0, _presentationPublishing.apiHasExecutionContext)(parentApi)) {
            onError(new Error('Parent API does not have execution context'));
          }
          const {
            filters: globalFilters,
            query: globalQuery,
            timeRange
          } = (0, _presentationPublishing.useFetchContext)(api);
          const [dataViews, esqlQuery, viewType, showPreviewByDefault] = (0, _presentationPublishing.useBatchedPublishingSubjects)(api.dataViews, api.query$, api.viewType$, api.showDistributions$);
          const lastReloadRequestTime = (0, _useObservable.default)(reload$, Date.now());
          const isEsqlMode = viewType === _types.FieldStatsInitializerViewType.ESQL;
          const dataView = Array.isArray(dataViews) && dataViews.length > 0 ? dataViews[0] : undefined;
          const onAddFilter = (field, value, operator) => {
            if (!dataView || !pluginStart.data) {
              toasts.addWarning(ERROR_MSG.APPLY_FILTER_ERR);
              return;
            }
            let filters = (0, _public.generateFilters)(pluginStart.data.query.filterManager, field, value, operator, dataView);
            filters = filters.map(filter => ({
              ...filter,
              $state: {
                store: _esQuery.FilterStateStore.APP_STATE
              }
            }));
            addFilters(filters);
          };

          // On destroy
          (0, _react.useEffect)(() => {
            return () => {
              subscriptions === null || subscriptions === void 0 ? void 0 : subscriptions.unsubscribe();
              onFieldStatsTableDestroy();
            };
          }, []);
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            css: statsTableCss,
            "data-test-subj": "dashboardFieldStatsEmbeddedContent"
          }, /*#__PURE__*/_react.default.createElement(FieldStatisticsWrapper, {
            id: _field_stats_component_type.FieldStatsComponentType.DashboardEmbeddable,
            shouldGetSubfields: false,
            dataView: dataView,
            esqlQuery: esqlQuery,
            query: globalQuery,
            filters: globalFilters,
            lastReloadRequestTime: lastReloadRequestTime,
            isEsqlMode: isEsqlMode,
            onTableUpdate: onTableUpdate,
            showPreviewByDefault: showPreviewByDefault,
            onAddFilter: onAddFilter,
            resetData$: reset$,
            timeRange: timeRange,
            onRenderComplete: dataLoadingApi.onRenderComplete
          }));
        }
      };
    }
  };
  return factory;
};
exports.getFieldStatsChartEmbeddableFactory = getFieldStatsChartEmbeddableFactory;