"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportView = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _results_links = require("../../../common/components/results_links");
var _filebeat_config_flyout = require("../../../common/components/filebeat_config_flyout");
var _import_progress = require("../import_progress");
var _import_errors = require("../import_errors");
var _import_summary = require("../import_summary");
var _import_settings = require("../import_settings");
var _doc_count_chart = require("../doc_count_chart");
var _combined_fields = require("../../../common/components/combined_fields");
var _constants = require("../file_data_visualizer_view/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_INDEX_SETTINGS = {};
const CONFIG_MODE = {
  SIMPLE: 0,
  ADVANCED: 1
};
const DEFAULT_STATE = {
  index: '',
  importing: false,
  imported: false,
  initialized: false,
  reading: false,
  readProgress: 0,
  readStatus: _import_progress.IMPORT_STATUS.INCOMPLETE,
  parseJSONStatus: _import_progress.IMPORT_STATUS.INCOMPLETE,
  indexCreatedStatus: _import_progress.IMPORT_STATUS.INCOMPLETE,
  dataViewCreatedStatus: _import_progress.IMPORT_STATUS.INCOMPLETE,
  ingestPipelineCreatedStatus: _import_progress.IMPORT_STATUS.INCOMPLETE,
  permissionCheckStatus: _import_progress.IMPORT_STATUS.INCOMPLETE,
  uploadProgress: 0,
  uploadStatus: _import_progress.IMPORT_STATUS.INCOMPLETE,
  createDataView: true,
  dataView: '',
  dataViewId: '',
  ingestPipelineId: '',
  errors: [],
  importFailures: [],
  docCount: 0,
  configMode: CONFIG_MODE.SIMPLE,
  indexSettingsString: '',
  mappingsString: '',
  pipelineString: '',
  indexNames: [],
  dataViewNames: [],
  indexNameError: '',
  dataViewNameError: '',
  timeFieldName: undefined,
  isFilebeatFlyoutVisible: false,
  checkingValidIndex: false,
  combinedFields: [],
  importer: undefined
};
class ImportView extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "clickReset", () => {
      const state = getDefaultState(this.state, this.props.results, this.props.capabilities);
      this.setState(state, () => {
        this.loadDataViewNames();
      });
    });
    (0, _defineProperty2.default)(this, "clickImport", () => {
      this.import();
    });
    (0, _defineProperty2.default)(this, "onConfigModeChange", configMode => {
      this.setState({
        configMode
      });
    });
    (0, _defineProperty2.default)(this, "onIndexChange", e => {
      const index = e.target.value;
      this.setState({
        index,
        checkingValidIndex: true
      });
      this.debounceIndexCheck(index);
    });
    (0, _defineProperty2.default)(this, "debounceIndexCheck", (0, _lodash.debounce)(async index => {
      if (index === '') {
        this.setState({
          checkingValidIndex: false
        });
        return;
      }
      const exists = await this.props.fileUpload.checkIndexExists(index);
      const indexNameError = exists ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.importView.indexNameAlreadyExistsErrorMessage",
        defaultMessage: "Index name already exists"
      }) : isIndexNameValid(index);
      this.setState({
        checkingValidIndex: false,
        indexNameError
      });
    }, 500));
    (0, _defineProperty2.default)(this, "onDataViewChange", e => {
      const name = e.target.value;
      const {
        dataViewNames,
        index
      } = this.state;
      this.setState({
        dataView: name,
        dataViewNameError: isDataViewNameValid(name, dataViewNames, index)
      });
    });
    (0, _defineProperty2.default)(this, "onCreateDataViewChange", e => {
      this.setState({
        createDataView: e.target.checked
      });
    });
    (0, _defineProperty2.default)(this, "onIndexSettingsStringChange", text => {
      this.setState({
        indexSettingsString: text
      });
    });
    (0, _defineProperty2.default)(this, "onMappingsStringChange", text => {
      this.setState({
        mappingsString: text
      });
    });
    (0, _defineProperty2.default)(this, "onPipelineStringChange", text => {
      this.setState({
        pipelineString: text
      });
    });
    (0, _defineProperty2.default)(this, "onCombinedFieldsChange", combinedFields => {
      this.setState({
        combinedFields
      });
    });
    (0, _defineProperty2.default)(this, "setImportProgress", progress => {
      this.setState({
        uploadProgress: progress
      });
    });
    (0, _defineProperty2.default)(this, "setReadProgress", progress => {
      this.setState({
        readProgress: progress
      });
    });
    (0, _defineProperty2.default)(this, "showFilebeatFlyout", () => {
      this.setState({
        isFilebeatFlyoutVisible: true
      });
    });
    (0, _defineProperty2.default)(this, "closeFilebeatFlyout", () => {
      this.setState({
        isFilebeatFlyoutVisible: false
      });
    });
    this.state = getDefaultState(DEFAULT_STATE, this.props.results, this.props.capabilities);
    this.dataViewsContract = props.dataViewsContract;
  }
  componentDidMount() {
    this.loadDataViewNames();
  }
  // TODO - sort this function out. it's a mess
  async import() {
    const {
      data,
      results,
      dataViewsContract,
      fileUpload
    } = this.props;
    const {
      format
    } = results;
    let {
      timeFieldName
    } = this.state;
    const {
      index,
      dataView,
      createDataView,
      indexSettingsString,
      mappingsString,
      pipelineString
    } = this.state;
    const errors = [];
    if (index !== '') {
      this.setState({
        importing: true,
        errors
      }, async () => {
        // check to see if the user has permission to create and ingest data into the specified index
        if ((await fileUpload.hasImportPermission({
          checkCreateDataView: createDataView,
          checkHasManagePipeline: true,
          indexName: index
        })) === false) {
          errors.push(_i18n.i18n.translate('xpack.dataVisualizer.file.importView.importPermissionError', {
            defaultMessage: 'You do not have permission to create or import data into index {index}.',
            values: {
              index
            }
          }));
          this.setState({
            permissionCheckStatus: _import_progress.IMPORT_STATUS.FAILED,
            importing: false,
            imported: false,
            errors
          });
          return;
        }
        this.setState({
          importing: true,
          imported: false,
          reading: true,
          initialized: true,
          permissionCheckStatus: _import_progress.IMPORT_STATUS.COMPLETE
        }, () => {
          setTimeout(async () => {
            let success = true;
            const createPipeline = pipelineString !== '';
            let settings = {};
            let mappings = {};
            let pipeline = {};
            try {
              settings = JSON.parse(indexSettingsString);
            } catch (error) {
              success = false;
              const parseError = _i18n.i18n.translate('xpack.dataVisualizer.file.importView.parseSettingsError', {
                defaultMessage: 'Error parsing settings:'
              });
              errors.push(`${parseError} ${error.message}`);
            }
            try {
              mappings = JSON.parse(mappingsString);
            } catch (error) {
              success = false;
              const parseError = _i18n.i18n.translate('xpack.dataVisualizer.file.importView.parseMappingsError', {
                defaultMessage: 'Error parsing mappings:'
              });
              errors.push(`${parseError} ${error.message}`);
            }
            try {
              if (createPipeline) {
                pipeline = JSON.parse(pipelineString);
              }
            } catch (error) {
              success = false;
              const parseError = _i18n.i18n.translate('xpack.dataVisualizer.file.importView.parsePipelineError', {
                defaultMessage: 'Error parsing ingest pipeline:'
              });
              errors.push(`${parseError} ${error.message}`);
            }
            this.setState({
              parseJSONStatus: success ? _import_progress.IMPORT_STATUS.COMPLETE : _import_progress.IMPORT_STATUS.FAILED
            });
            if (success) {
              const importer = await fileUpload.importerFactory(format, {
                excludeLinesPattern: results.exclude_lines_pattern,
                multilineStartPattern: results.multiline_start_pattern
              });
              if (importer !== undefined) {
                const readResp = importer.read(data, this.setReadProgress);
                success = readResp.success;
                this.setState({
                  readStatus: success ? _import_progress.IMPORT_STATUS.COMPLETE : _import_progress.IMPORT_STATUS.FAILED,
                  reading: false,
                  importer
                });
                if (readResp.success === false) {
                  console.error(readResp.error);
                  errors.push(readResp.error);
                }
                if (success) {
                  const initializeImportResp = await importer.initializeImport(index, settings, mappings, pipeline);
                  timeFieldName = importer.getTimeField();
                  this.setState({
                    timeFieldName
                  });
                  const indexCreated = initializeImportResp.index !== undefined;
                  this.setState({
                    indexCreatedStatus: indexCreated ? _import_progress.IMPORT_STATUS.COMPLETE : _import_progress.IMPORT_STATUS.FAILED
                  });
                  if (createPipeline) {
                    const pipelineCreated = initializeImportResp.pipelineId !== undefined;
                    if (indexCreated) {
                      this.setState({
                        ingestPipelineCreatedStatus: pipelineCreated ? _import_progress.IMPORT_STATUS.COMPLETE : _import_progress.IMPORT_STATUS.FAILED,
                        ingestPipelineId: pipelineCreated ? initializeImportResp.pipelineId : ''
                      });
                    }
                    success = indexCreated && pipelineCreated;
                  } else {
                    success = indexCreated;
                  }
                  if (success) {
                    const importId = initializeImportResp.id;
                    const pipelineId = initializeImportResp.pipelineId;
                    const importResp = await importer.import(importId, index, pipelineId, this.setImportProgress);
                    success = importResp.success;
                    this.setState({
                      uploadStatus: importResp.success ? _import_progress.IMPORT_STATUS.COMPLETE : _import_progress.IMPORT_STATUS.FAILED,
                      importFailures: importResp.failures,
                      docCount: importResp.docCount
                    });
                    if (success) {
                      if (createDataView) {
                        const dataViewName = dataView === '' ? index : dataView;
                        const dataViewResp = await createKibanaDataView(dataViewName, dataViewsContract, timeFieldName);
                        success = dataViewResp.success;
                        this.setState({
                          dataViewCreatedStatus: dataViewResp.success ? _import_progress.IMPORT_STATUS.COMPLETE : _import_progress.IMPORT_STATUS.FAILED,
                          dataViewId: dataViewResp.id
                        });
                        if (dataViewResp.success === false) {
                          errors.push(dataViewResp.error);
                        }
                      }
                    } else {
                      errors.push(importResp.error);
                    }
                  } else {
                    errors.push(initializeImportResp.error);
                  }
                }
              }
            }
            this.setState({
              importing: false,
              imported: success,
              errors
            });
          }, 500);
        });
      });
    }
  }
  async loadDataViewNames() {
    try {
      const dataViewNames = await this.dataViewsContract.getTitles();
      this.setState({
        dataViewNames
      });
    } catch (error) {
      console.error('failed to load data views', error);
    }
  }
  render() {
    var _this$props$results, _this$props$getAdditi;
    const {
      index,
      dataView,
      dataViewId,
      ingestPipelineId,
      importing,
      imported,
      reading,
      initialized,
      readStatus,
      parseJSONStatus,
      indexCreatedStatus,
      ingestPipelineCreatedStatus,
      dataViewCreatedStatus,
      permissionCheckStatus,
      uploadProgress,
      uploadStatus,
      createDataView,
      errors,
      docCount,
      importFailures,
      indexSettingsString,
      mappingsString,
      pipelineString,
      indexNameError,
      dataViewNameError,
      timeFieldName,
      isFilebeatFlyoutVisible,
      checkingValidIndex,
      combinedFields,
      importer
    } = this.state;
    const createPipeline = pipelineString !== '';
    const statuses = {
      reading,
      readStatus,
      parseJSONStatus,
      indexCreatedStatus,
      ingestPipelineCreatedStatus,
      dataViewCreatedStatus,
      permissionCheckStatus,
      uploadProgress,
      uploadStatus,
      createDataView,
      createPipeline
    };
    const disableImport = index === '' || indexNameError !== '' || createDataView === true && dataViewNameError !== '' || initialized === true || checkingValidIndex === true;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
      "data-test-subj": "dataVisualizerPageFileImport"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h1", null, this.props.fileName))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), initialized === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      "data-test-subj": "dataVisualizerFileImportSettingsPanel",
      hasShadow: false,
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importView.importDataTitle",
      defaultMessage: "Import data"
    }))), /*#__PURE__*/_react.default.createElement(_import_settings.ImportSettings, {
      index: index,
      dataView: dataView,
      initialized: initialized,
      onIndexChange: this.onIndexChange,
      createDataView: createDataView,
      onCreateDataViewChange: this.onCreateDataViewChange,
      onDataViewChange: this.onDataViewChange,
      indexSettingsString: indexSettingsString,
      mappingsString: mappingsString,
      pipelineString: pipelineString,
      onIndexSettingsStringChange: this.onIndexSettingsStringChange,
      onMappingsStringChange: this.onMappingsStringChange,
      onPipelineStringChange: this.onPipelineStringChange,
      indexNameError: indexNameError,
      dataViewNameError: dataViewNameError,
      combinedFields: combinedFields,
      onCombinedFieldsChange: this.onCombinedFieldsChange,
      results: this.props.results
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isDisabled: disableImport,
      onClick: this.clickImport,
      isLoading: importing,
      iconSide: "right",
      fill: true,
      "data-test-subj": "dataVisualizerFileImportButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importView.importButtonLabel",
      defaultMessage: "Import"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => this.props.onChangeMode(_constants.MODE.READ),
      isDisabled: importing
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importView.backButtonLabel",
      defaultMessage: "Back"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => this.props.onCancel(),
      isDisabled: importing
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importView.cancelButtonLabel",
      defaultMessage: "Select a different file"
    }))))) : null, initialized === true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_import_progress.ImportProgress, {
      statuses: statuses
    }), importer !== undefined && importer.initialized() && /*#__PURE__*/_react.default.createElement(_doc_count_chart.DocCountChart, {
      statuses: statuses,
      dataStart: this.props.dataStart,
      importer: importer
    }), imported === true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_import_summary.ImportSummary, {
      index: index,
      dataView: dataView === '' ? index : dataView,
      ingestPipelineId: ingestPipelineId,
      docCount: docCount,
      importFailures: importFailures,
      createDataView: createDataView,
      createPipeline: createPipeline
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this.clickReset
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importView.resetButtonLabel",
      defaultMessage: "Reset"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => this.props.onCancel(),
      isDisabled: importing
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importView.importNewButtonLabel",
      defaultMessage: "Import a new file"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_results_links.ResultsLinks, {
      fieldStats: (_this$props$results = this.props.results) === null || _this$props$results === void 0 ? void 0 : _this$props$results.field_stats,
      index: index,
      dataViewId: dataViewId,
      timeFieldName: timeFieldName,
      createDataView: createDataView,
      showFilebeatFlyout: this.showFilebeatFlyout,
      getAdditionalLinks: (_this$props$getAdditi = this.props.getAdditionalLinks) !== null && _this$props$getAdditi !== void 0 ? _this$props$getAdditi : [],
      resultLinks: this.props.resultLinks
    }), isFilebeatFlyoutVisible && /*#__PURE__*/_react.default.createElement(_filebeat_config_flyout.FilebeatConfigFlyout, {
      index: index,
      results: this.props.results,
      ingestPipelineId: ingestPipelineId,
      closeFlyout: this.closeFilebeatFlyout
    })))), errors.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_import_errors.ImportErrors, {
      errors: errors,
      statuses: statuses
    })));
  }
}
exports.ImportView = ImportView;
async function createKibanaDataView(dataViewName, dataViewsContract, timeFieldName) {
  try {
    const emptyPattern = await dataViewsContract.createAndSave({
      title: dataViewName,
      timeFieldName
    });
    return {
      success: true,
      id: emptyPattern.id
    };
  } catch (error) {
    return {
      success: false,
      error
    };
  }
}
function getDefaultState(state, results, capabilities) {
  const indexSettingsString = state.indexSettingsString === '' ? JSON.stringify(DEFAULT_INDEX_SETTINGS, null, 2) : state.indexSettingsString;
  const combinedFields = state.combinedFields.length ? state.combinedFields : (0, _combined_fields.getDefaultCombinedFields)(results);
  const mappingsString = state.mappingsString === '' ? JSON.stringify((0, _combined_fields.addCombinedFieldsToMappings)(results.mappings, combinedFields), null, 2) : state.mappingsString;
  const pipelineString = state.pipelineString === '' && results.ingest_pipeline !== undefined ? JSON.stringify((0, _combined_fields.addCombinedFieldsToPipeline)(results.ingest_pipeline, combinedFields), null, 2) : state.pipelineString;
  const timeFieldName = results.timestamp_field;
  const createDataView = capabilities.savedObjectsManagement.edit === false && capabilities.indexPatterns.save === false ? false : state.createDataView;
  return {
    ...DEFAULT_STATE,
    indexSettingsString,
    mappingsString,
    pipelineString,
    timeFieldName,
    combinedFields,
    createDataView
  };
}
function isIndexNameValid(name) {
  const reg = new RegExp('[\\\\/*?"<>|\\s,#]+');
  if (name !== name.toLowerCase() ||
  // name should be lowercase
  name === '.' || name === '..' ||
  // name can't be . or ..
  name.match(/^[-_+]/) !== null ||
  // name can't start with these chars
  name.match(reg) !== null // name can't contain these chars
  ) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importView.indexNameContainsIllegalCharactersErrorMessage",
      defaultMessage: "Index name contains illegal characters"
    });
  }
  return '';
}
function isDataViewNameValid(name, dataViewNames, index) {
  // if a blank name is entered, the index name will be used so avoid validation
  if (name === '') {
    return '';
  }
  if (dataViewNames.find(i => i === name)) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importView.dataViewNameAlreadyExistsErrorMessage",
      defaultMessage: "Data view name already exists"
    });
  }

  // escape . and + to stop the regex matching more than it should.
  let newName = name.replace(/\./g, '\\.');
  newName = newName.replace(/\+/g, '\\+');
  // replace * with .* to make the wildcard match work.
  newName = newName.replace(/\*/g, '.*');
  const reg = new RegExp(`^${newName}$`);
  if (index.match(reg) === null) {
    // name should match index
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importView.indexPatternDoesNotMatchDataViewErrorMessage",
      defaultMessage: "Data view does not match index name"
    });
  }
  return '';
}