"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindFileStructurePermissionDenied = exports.FileTooLarge = exports.FileCouldNotBeRead = exports.Explanation = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileTooLarge = ({
  fileSize,
  maxFileSize
}) => {
  const fileSizeFormatted = (0, _numeral.default)(fileSize).format(_constants.FILE_SIZE_DISPLAY_FORMAT);
  const maxFileSizeFormatted = (0, _numeral.default)(maxFileSize).format(_constants.FILE_SIZE_DISPLAY_FORMAT);

  // Format the byte values, using the second format if the difference between
  // the file size and the max is so small that the formatted values are identical
  // e.g. 100.01 MB and 100.0 MB
  let errorText;
  if (fileSizeFormatted !== maxFileSizeFormatted) {
    errorText = /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.fileErrorCallouts.fileSizeExceedsAllowedSizeErrorMessage",
      defaultMessage: "The size of the file you selected for upload is {fileSizeFormatted} which exceeds the maximum permitted size of {maxFileSizeFormatted}",
      values: {
        fileSizeFormatted,
        maxFileSizeFormatted
      }
    }));
  } else {
    const diffFormatted = (0, _numeral.default)(fileSize - maxFileSize).format(_constants.FILE_SIZE_DISPLAY_FORMAT);
    errorText = /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.fileErrorCallouts.fileSizeExceedsAllowedSizeByDiffFormatErrorMessage",
      defaultMessage: "The size of the file you selected for upload exceeds the maximum permitted size of {maxFileSizeFormatted} by {diffFormatted}",
      values: {
        maxFileSizeFormatted,
        diffFormatted
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.fileErrorCallouts.fileSizeTooLargeTitle",
      defaultMessage: "File size is too large"
    }),
    color: "danger",
    iconType: "cross",
    "data-test-subj": "dataVisualizerFileUploadErrorCallout fileTooLarge"
  }, errorText);
};
exports.FileTooLarge = FileTooLarge;
const FileCouldNotBeRead = ({
  error,
  loaded,
  showEditFlyout
}) => {
  var _error$body;
  const message = (error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) || '';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.fileErrorCallouts.fileCouldNotBeReadTitle",
      defaultMessage: "File structure cannot be determined"
    }),
    color: "danger",
    iconType: "cross",
    "data-test-subj": "dataVisualizerFileUploadErrorCallout fileCouldNotBeRead"
  }, loaded === false && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileErrorCallouts.applyOverridesDescription",
    defaultMessage: "If you know something about this data, such as the file format or timestamp format, adding initial overrides may help us to infer the rest of the structure."
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: showEditFlyout,
    flush: "left",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileErrorCallouts.overrideButton",
    defaultMessage: "Apply override settings"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null)), message, /*#__PURE__*/_react.default.createElement(Explanation, {
    error: error
  }), loaded && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileErrorCallouts.revertingToPreviousSettingsDescription",
    defaultMessage: "Reverting to previous settings"
  }))));
};
exports.FileCouldNotBeRead = FileCouldNotBeRead;
const Explanation = ({
  error
}) => {
  var _error$body2, _error$body2$attribut, _error$body2$attribut2, _error$body2$attribut3, _error$body2$attribut4;
  if (!(error !== null && error !== void 0 && (_error$body2 = error.body) !== null && _error$body2 !== void 0 && (_error$body2$attribut = _error$body2.attributes) !== null && _error$body2$attribut !== void 0 && (_error$body2$attribut2 = _error$body2$attribut.body) !== null && _error$body2$attribut2 !== void 0 && (_error$body2$attribut3 = _error$body2$attribut2.error) !== null && _error$body2$attribut3 !== void 0 && (_error$body2$attribut4 = _error$body2$attribut3.suppressed) !== null && _error$body2$attribut4 !== void 0 && _error$body2$attribut4.length)) {
    return null;
  }
  const reason = error.body.attributes.body.error.suppressed[0].reason;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), reason.split('\n').map((m, i) => /*#__PURE__*/_react.default.createElement("div", {
    key: i
  }, m)));
};
exports.Explanation = Explanation;
const FindFileStructurePermissionDenied = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.fileErrorCallouts.findFileStructurePermissionDenied.title",
      defaultMessage: "Permission denied"
    }),
    color: "danger",
    iconType: "cross",
    "data-test-subj": "dataVisualizerFileStructurePermissionDeniedErrorCallout"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileErrorCallouts.findFileStructurePermissionDenied.description",
    defaultMessage: "You do not have sufficient privileges to analyze files."
  })));
};
exports.FindFileStructurePermissionDenied = FindFileStructurePermissionDenied;