"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalysisSummary = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalysisSummary = ({
  results
}) => {
  const items = createDisplayItems(results);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.analysisSummary.summaryTitle",
    defaultMessage: "Summary"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    columnWidths: [15, 85],
    listItems: items,
    className: "analysis-summary-list"
  }));
};
exports.AnalysisSummary = AnalysisSummary;
function createDisplayItems(results) {
  const items = [{
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.analysisSummary.analyzedLinesNumberTitle",
      defaultMessage: "Number of lines analyzed"
    }),
    description: results.num_lines_analyzed
  }
  // {
  //   title: 'Charset',
  //   description: results.charset,
  // }
  ];
  if (results.format !== undefined) {
    items.push({
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.analysisSummary.formatTitle",
        defaultMessage: "Format"
      }),
      description: results.format
    });
    if (results.format === _constants.FILE_FORMATS.DELIMITED) {
      items.push({
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.dataVisualizer.file.analysisSummary.delimiterTitle",
          defaultMessage: "Delimiter"
        }),
        description: results.delimiter
      });
      items.push({
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.dataVisualizer.file.analysisSummary.hasHeaderRowTitle",
          defaultMessage: "Has header row"
        }),
        description: `${results.has_header_row}`
      });
    }
  }
  if (results.grok_pattern !== undefined) {
    items.push({
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.analysisSummary.grokPatternTitle",
        defaultMessage: "Grok pattern"
      }),
      description: results.grok_pattern
    });
  }
  if (results.timestamp_field !== undefined) {
    items.push({
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.analysisSummary.timeFieldTitle",
        defaultMessage: "Time field"
      }),
      description: results.timestamp_field
    });
  }
  if (results.java_timestamp_formats !== undefined) {
    items.push({
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.analysisSummary.timeFormatTitle",
        defaultMessage: "Time {timestampFormats, plural, zero {format} one {format} other {formats}}",
        values: {
          timestampFormats: results.java_timestamp_formats.length
        }
      }),
      description: results.java_timestamp_formats.join(', ')
    });
  }
  return items;
}