"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CombinedFieldLabel = CombinedFieldLabel;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CombinedFieldLabel({
  combinedField
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, getCombinedFieldLabel(combinedField));
}
function getCombinedFieldLabel(combinedField) {
  return `${combinedField.fieldNames.join(combinedField.delimiter)} => ${combinedField.combinedFieldName} (${combinedField.mappingType})`;
}