"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCreateDataViewRouteLegacy = exports.registerCreateDataViewRoute = exports.createDataView = void 0;
var _configSchema = require("@kbn/config-schema");
var _handle_errors = require("./util/handle_errors");
var _schema = require("../schema");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createDataView = async ({
  dataViewsService,
  usageCollection,
  spec,
  override,
  counterName
}) => {
  usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.incrementCounter({
    counterName
  });
  return dataViewsService.createAndSaveDataViewLazy(spec, override);
};
exports.createDataView = createDataView;
const registerCreateDataViewRouteFactory = (path, serviceKey, description) => (router, getStartServices, usageCollection) => {
  router.versioned.post({
    path,
    access: 'public',
    description
  }).addVersion({
    version: _constants.INITIAL_REST_VERSION,
    validate: {
      request: {
        body: _configSchema.schema.object({
          override: _configSchema.schema.maybe(_configSchema.schema.boolean({
            defaultValue: false
          })),
          refresh_fields: _configSchema.schema.maybe(_configSchema.schema.boolean({
            defaultValue: false
          })),
          data_view: serviceKey === _constants.SERVICE_KEY ? _schema.dataViewSpecSchema : _configSchema.schema.never(),
          index_pattern: serviceKey === _constants.SERVICE_KEY_LEGACY ? _schema.dataViewSpecSchema : _configSchema.schema.never()
        })
      },
      response: {
        200: {
          body: () => _configSchema.schema.object({
            [serviceKey]: _schema.dataViewSpecSchema
          })
        }
      }
    }
  }, router.handleLegacyErrors((0, _handle_errors.handleErrors)(async (ctx, req, res) => {
    const core = await ctx.core;
    const savedObjectsClient = core.savedObjects.client;
    const elasticsearchClient = core.elasticsearch.client.asCurrentUser;
    const [,, {
      dataViewsServiceFactory
    }] = await getStartServices();
    const dataViewsService = await dataViewsServiceFactory(savedObjectsClient, elasticsearchClient, req);
    const body = req.body;
    const spec = serviceKey === _constants.SERVICE_KEY ? body.data_view : body.index_pattern;
    const dataView = await createDataView({
      dataViewsService,
      usageCollection,
      spec: {
        ...spec,
        name: spec.name || spec.title
      },
      override: body.override,
      refreshFields: body.refresh_fields,
      counterName: `${req.route.method} ${path}`
    });
    const toSpecParams = body.refresh_fields === false ? {} : {
      fieldParams: {
        fieldName: ['*']
      }
    };
    const responseBody = {
      [serviceKey]: {
        ...(await dataView.toSpec(toSpecParams)),
        namespaces: dataView.namespaces
      }
    };
    return res.ok({
      headers: {
        'content-type': 'application/json'
      },
      body: responseBody
    });
  })));
};
const registerCreateDataViewRoute = exports.registerCreateDataViewRoute = registerCreateDataViewRouteFactory(_constants.DATA_VIEW_PATH, _constants.SERVICE_KEY, _constants.CREATE_DATA_VIEW_DESCRIPTION);
const registerCreateDataViewRouteLegacy = exports.registerCreateDataViewRouteLegacy = registerCreateDataViewRouteFactory(_constants.DATA_VIEW_PATH_LEGACY, _constants.SERVICE_KEY_LEGACY);