"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewsServicePublic = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _ = require(".");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Data Views public service dependencies
 * @public
 */

/**
 * Data Views public service
 * @public
 */
class DataViewsServicePublic extends _.DataViewsService {
  /**
   * Constructor
   * @param deps Service dependencies
   */

  constructor(deps) {
    super(deps);
    (0, _defineProperty2.default)(this, "getCanSaveSync", void 0);
    (0, _defineProperty2.default)(this, "getIndices", void 0);
    (0, _defineProperty2.default)(this, "hasData", void 0);
    (0, _defineProperty2.default)(this, "rollupsEnabled", false);
    (0, _defineProperty2.default)(this, "http", void 0);
    (0, _defineProperty2.default)(this, "scriptedFieldsEnabled", void 0);
    this.getCanSaveSync = deps.getCanSaveSync;
    this.hasData = deps.hasData;
    this.getIndices = deps.getIndices;
    this.rollupsEnabled = deps.getRollupsEnabled();
    this.scriptedFieldsEnabled = deps.scriptedFieldsEnabled;
    this.http = deps.http;
  }
  getRollupsEnabled() {
    return this.rollupsEnabled;
  }

  /**
   * Get existing index pattern list by providing string array index pattern list.
   * @param indices - index pattern list
   * @returns index pattern list of index patterns that match indices
   */
  async getExistingIndices(indices) {
    return this.http.get(_constants.EXISTING_INDICES_PATH, {
      query: {
        indices
      },
      version: '1'
    });
  }
}
exports.DataViewsServicePublic = DataViewsServicePublic;