"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataViewTableControllerStateDefaults = exports.DataViewTableController = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _utils = require("../utils");
var _state_helpers = require("../state_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const dataViewTableControllerStateDefaults = exports.dataViewTableControllerStateDefaults = {
  isLoadingDataViews: false,
  isLoadingHasData: true,
  hasDataView: false,
  hasEsData: false,
  dataViews: []
};
const selectIndexPattern = state => state.dataViews;
const selectHasDataView = state => state.hasDataView;
const selectHasEsData = state => state.hasEsData;
const selectIsLoadingIndexPatterns = state => state.isLoadingDataViews;
const selectIsLoadingDataState = state => state.isLoadingHasData;
class DataViewTableController {
  constructor({
    services: {
      dataViews: _dataViews
    },
    config: {
      defaultDataView
    }
  }) {
    (0, _defineProperty2.default)(this, "state", {
      ...dataViewTableControllerStateDefaults
    });
    (0, _defineProperty2.default)(this, "state$", new _rxjs.BehaviorSubject(this.state));
    (0, _defineProperty2.default)(this, "dataViews", void 0);
    (0, _defineProperty2.default)(this, "defaultDataView", void 0);
    (0, _defineProperty2.default)(this, "isLoadingIndexPatterns$", void 0);
    (0, _defineProperty2.default)(this, "indexPatterns$", void 0);
    (0, _defineProperty2.default)(this, "isLoadingDataState$", void 0);
    (0, _defineProperty2.default)(this, "hasDataView$", void 0);
    (0, _defineProperty2.default)(this, "hasESData$", void 0);
    (0, _defineProperty2.default)(this, "updateState", newState => {
      this.state = {
        ...this.state,
        ...newState
      };
      this.state$.next(this.state);
    });
    (0, _defineProperty2.default)(this, "loadHasData", async () => {
      const hasDataViewPromise = this.dataViews.hasData.hasDataView().then(hasDataView => {
        this.updateState({
          hasDataView
        });
      });
      const hasESDataPromise = this.dataViews.hasData.hasESData().then(hasEsData => {
        this.updateState({
          hasEsData
        });
      });
      return Promise.all([hasDataViewPromise, hasESDataPromise]).then(() => {
        this.updateState({
          isLoadingHasData: false
        });
      });
    });
    (0, _defineProperty2.default)(this, "getDataViews", async () => {
      this.updateState({
        isLoadingDataViews: true
      });
      const dataViews = await (0, _utils.getIndexPatterns)(this.defaultDataView, this.dataViews);
      this.updateState({
        dataViews,
        isLoadingDataViews: false
      });
    });
    (0, _defineProperty2.default)(this, "loadDataViews", async () => {
      const loadHasDataPromise = this.loadHasData();
      const getDataViewsPromise = this.getDataViews();
      return Promise.all([loadHasDataPromise, getDataViewsPromise]);
    });
    this.dataViews = _dataViews;
    this.defaultDataView = defaultDataView;
    const stateSelector = (0, _state_helpers.stateSelectorFactory)(this.state$);
    this.isLoadingIndexPatterns$ = stateSelector(selectIsLoadingIndexPatterns);
    this.indexPatterns$ = stateSelector(selectIndexPattern, _lodash.isEqual);
    this.isLoadingDataState$ = stateSelector(selectIsLoadingDataState);
    this.hasDataView$ = stateSelector(selectHasDataView);
    this.hasESData$ = stateSelector(selectHasEsData);
    this.loadDataViews();
  }
}
exports.DataViewTableController = DataViewTableController;