"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScriptingSyntax = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ScriptingSyntax = () => {
  var _useKibana$services$d;
  const docLinksScriptedFields = (_useKibana$services$d = (0, _public.useKibana)().services.docLinks) === null || _useKibana$services$d === void 0 ? void 0 : _useKibana$services$d.links.scriptedFields;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.syntaxHeader",
    defaultMessage: "Syntax"
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.syntax.defaultLabel.defaultDetail",
    defaultMessage: "By default, Kibana scripted fields use {painless}, a simple and secure scripting language designed specifically for use with Elasticsearch, to access values in the document use the following format:",
    values: {
      painless: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: docLinksScriptedFields.painless
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternManagement.syntax.defaultLabel.painlessLink",
        defaultMessage: "Painless"
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "link"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.syntax.default.formatLabel",
    defaultMessage: "doc['some_field'].value"
  }))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.syntax.painlessLabel.painlessDetail",
    defaultMessage: "Painless is powerful but easy to use. It provides access to many {javaAPIs}. Read up on its {syntax} and you'll be up to speed in no time!",
    values: {
      javaAPIs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: docLinksScriptedFields.painlessApi
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternManagement.syntax.painlessLabel.javaAPIsLink",
        defaultMessage: "native Java APIs"
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "link"
      })),
      syntax: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: docLinksScriptedFields.painlessSyntax
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternManagement.syntax.painlessLabel.syntaxLink",
        defaultMessage: "syntax"
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "link"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.syntax.kibanaLabel",
    defaultMessage: "Kibana currently imposes one special limitation on the painless scripts you write. They cannot contain named functions."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.commonLabel.commonDetail",
    defaultMessage: "Coming from an older version of Kibana? The {lucene} you know and love are still available. Lucene expressions are a lot like JavaScript, but limited to basic arithmetic, bitwise and comparison operations.",
    values: {
      lucene: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: docLinksScriptedFields.luceneExpressions
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternManagement.syntax.lucene.commonLabel.luceneLink",
        defaultMessage: "Lucene Expressions"
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "link"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.limitsLabel",
    defaultMessage: "There are a few limitations when using Lucene Expressions:"
  })), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.limits.typesLabel",
    defaultMessage: "Only numeric, boolean, date, and geo_point fields may be accessed"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.limits.fieldsLabel",
    defaultMessage: "Stored fields are not available"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.limits.sparseLabel",
    defaultMessage: "If a field is sparse (only some documents contain a value), documents missing the field will have a value of 0"
  }))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.operationsLabel",
    defaultMessage: "Here are all the operations available to lucene expressions:"
  })), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.operations.arithmeticLabel",
    defaultMessage: "Arithmetic operators: {operators}",
    values: {
      operators: /*#__PURE__*/_react.default.createElement("code", null, "+ - * / %")
    }
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.operations.bitwiseLabel",
    defaultMessage: "Bitwise operators: {operators}",
    values: {
      operators: /*#__PURE__*/_react.default.createElement("code", null, "| & ^ ~ << >> >>>")
    }
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.operations.booleanLabel",
    defaultMessage: "Boolean operators (including the ternary operator): {operators}",
    values: {
      operators: /*#__PURE__*/_react.default.createElement("code", null, "&& || ! ?:")
    }
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.operations.comparisonLabel",
    defaultMessage: "Comparison operators: {operators}",
    values: {
      operators: /*#__PURE__*/_react.default.createElement("code", null, "< <= == >= >")
    }
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.operations.mathLabel",
    defaultMessage: "Common mathematic functions: {operators}",
    values: {
      operators: /*#__PURE__*/_react.default.createElement("code", null, "abs ceil exp floor ln log10 logn max min sqrt pow")
    }
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.operations.trigLabel",
    defaultMessage: "Trigonometric library functions: {operators}",
    values: {
      operators: /*#__PURE__*/_react.default.createElement("code", null, "acosh acos asinh asin atanh atan atan2 cosh cos sinh sin tanh tan")
    }
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.operations.distanceLabel",
    defaultMessage: "Distance functions: {operators}",
    values: {
      operators: /*#__PURE__*/_react.default.createElement("code", null, "haversin")
    }
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.operations.miscellaneousLabel",
    defaultMessage: "Miscellaneous functions: {operators}",
    values: {
      operators: /*#__PURE__*/_react.default.createElement("code", null, "min, max")
    }
  })))));
};
exports.ScriptingSyntax = ScriptingSyntax;