"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldFormatEditor = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// use memoize to get stable reference
const unwrapEditor = (0, _lodash.memoize)(editorFactory => {
  if (!editorFactory) return null;
  return /*#__PURE__*/_react.default.lazy(() => editorFactory().then(editor => ({
    default: editor
  })));
});
class FieldFormatEditor extends _react.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      EditorComponent: unwrapEditor(props.fieldFormatEditors.getById(props.fieldFormatId))
    };
  }
  static getDerivedStateFromProps(nextProps) {
    return {
      EditorComponent: unwrapEditor(nextProps.fieldFormatEditors.getById(nextProps.fieldFormatId))
    };
  }
  render() {
    const {
      EditorComponent
    } = this.state;
    const {
      fieldType,
      fieldFormat,
      fieldFormatParams,
      onChange,
      onError
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, EditorComponent ? /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
      fallback:
      /*#__PURE__*/
      // We specify minHeight to avoid too mitigate layout shifts while loading an editor
      // ~430 corresponds to "4 lines" of EuiSkeletonText
      _react.default.createElement("div", {
        style: {
          minHeight: 430,
          marginTop: 8
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiDelayRender, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 4
      })))
    }, /*#__PURE__*/_react.default.createElement(EditorComponent, {
      fieldType: fieldType,
      format: fieldFormat,
      formatParams: fieldFormatParams,
      onChange: onChange,
      onError: onError
    })) : null);
  }
}
exports.FieldFormatEditor = FieldFormatEditor;