"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteFilterConfirmationModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DeleteFilterConfirmationModal = ({
  filterToDeleteValue,
  onCancelConfirmationModal,
  onDeleteFilter
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternManagement.editIndexPattern.source.deleteSourceFilterLabel",
      defaultMessage: "Delete field filter ''{value}''?",
      values: {
        value: filterToDeleteValue
      }
    }),
    onCancel: onCancelConfirmationModal,
    onConfirm: onDeleteFilter,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternManagement.editIndexPattern.source.deleteFilter.cancelButtonLabel",
      defaultMessage: "Cancel"
    }),
    buttonColor: "danger",
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternManagement.editIndexPattern.source.deleteFilter.deleteButtonLabel",
      defaultMessage: "Delete"
    }),
    defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON
  });
};
exports.DeleteFilterConfirmationModal = DeleteFilterConfirmationModal;
DeleteFilterConfirmationModal.propTypes = {
  filterToDeleteValue: _propTypes.default.string.isRequired,
  onCancelConfirmationModal: _propTypes.default.func.isRequired,
  onDeleteFilter: _propTypes.default.func.isRequired
};