"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Table = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class Table extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "renderFormatCell", value => {
      const {
        indexPattern
      } = this.props;
      const title = (0, _lodash.get)(indexPattern, ['fieldFormatMap', value, 'type', 'title'], '');
      return /*#__PURE__*/_react.default.createElement("span", null, title);
    });
  }
  render() {
    const {
      items,
      editField,
      deleteField
    } = this.props;
    const columns = [{
      field: 'displayName',
      name: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.nameHeader', {
        defaultMessage: 'Name'
      }),
      description: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.nameDescription', {
        defaultMessage: 'Name of the field'
      }),
      dataType: 'string',
      sortable: true,
      width: '38%'
    }, {
      field: 'lang',
      name: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.langHeader', {
        defaultMessage: 'Lang'
      }),
      description: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.langDescription', {
        defaultMessage: 'Language used for the field'
      }),
      dataType: 'string',
      sortable: true,
      'data-test-subj': 'scriptedFieldLang'
    }, {
      field: 'script',
      name: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.scriptHeader', {
        defaultMessage: 'Script'
      }),
      description: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.scriptDescription', {
        defaultMessage: 'Script for the field'
      }),
      dataType: 'string',
      sortable: true
    }, {
      field: 'name',
      name: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.formatHeader', {
        defaultMessage: 'Format'
      }),
      description: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.formatDescription', {
        defaultMessage: 'Format used for the field'
      }),
      render: this.renderFormatCell,
      sortable: false
    }, {
      name: '',
      actions: [{
        type: 'icon',
        name: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.editHeader', {
          defaultMessage: 'Edit'
        }),
        description: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.editDescription', {
          defaultMessage: 'Edit this field'
        }),
        icon: 'pencil',
        onClick: editField,
        available: field => !!field.isUserEditable
      }, {
        type: 'icon',
        name: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.deleteHeader', {
          defaultMessage: 'Delete'
        }),
        description: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.deleteDescription', {
          defaultMessage: 'Delete this field'
        }),
        icon: 'trash',
        color: 'danger',
        onClick: deleteField,
        available: field => !!field.isUserEditable
      }],
      width: '40px'
    }];
    const pagination = {
      initialPageSize: 10,
      pageSizeOptions: [5, 10, 25, 50]
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      items: items,
      columns: columns,
      pagination: pagination,
      sorting: true
    });
  }
}
exports.Table = Table;