"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldEditorOpener = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _field_editor_loader = require("./components/field_editor_loader");
var _constants = require("./constants");
var _shared_imports = require("./shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Options for opening the field editor
 * @public
 */

const getFieldEditorOpener = ({
  core,
  dataViews,
  fieldFormats,
  fieldFormatEditors,
  search,
  usageCollection,
  apiService
}) => async options => {
  const {
    uiSettings,
    overlays,
    docLinks,
    notifications,
    settings,
    theme
  } = core;
  const {
    Provider: KibanaReactContextProvider
  } = (0, _shared_imports.createKibanaReactContext)({
    uiSettings,
    docLinks,
    http: core.http,
    settings,
    theme
  });
  let overlayRef = null;
  const canCloseValidator = {
    current: () => true
  };
  const onMounted = args => {
    canCloseValidator.current = args.canCloseValidator;
  };
  const openEditor = async ({
    onSave,
    fieldName: fieldNameToEdit,
    fieldToCreate,
    ctx: {
      dataView: dataViewLazyOrNot
    }
  }) => {
    const closeEditor = () => {
      if (overlayRef) {
        overlayRef.close();
        overlayRef = null;
      }
    };
    const onSaveField = updatedField => {
      closeEditor();
      if (onSave) {
        onSave(updatedField);
      }
    };
    const getRuntimeField = name => {
      const fld = dataViewLazyOrNot.getAllRuntimeFields()[name];
      return {
        name,
        runtimeField: fld,
        isMapped: false,
        esTypes: [],
        type: undefined,
        customLabel: undefined,
        customDescription: undefined,
        count: undefined,
        spec: {
          parentName: undefined
        }
      };
    };
    const dataView = dataViewLazyOrNot instanceof _shared_imports.DataView ? dataViewLazyOrNot : await dataViews.toDataView(dataViewLazyOrNot);
    const dataViewField = fieldNameToEdit ? dataView.getFieldByName(fieldNameToEdit) || getRuntimeField(fieldNameToEdit) : undefined;
    if (fieldNameToEdit && !dataViewField) {
      const err = _i18n.i18n.translate('indexPatternFieldEditor.noSuchFieldName', {
        defaultMessage: "Field named ''{fieldName}'' not found on index pattern",
        values: {
          fieldName: fieldNameToEdit
        }
      });
      notifications.toasts.addDanger(err);
      return closeEditor;
    }
    const isNewRuntimeField = !fieldNameToEdit;
    const isExistingRuntimeField = dataViewField && dataViewField.runtimeField && !dataViewField.isMapped && (
    // treat composite subfield instances as mapped fields for field editing purposes
    dataViewField.runtimeField.type !== 'composite' || !dataViewField.type);
    const fieldTypeToProcess = isNewRuntimeField || isExistingRuntimeField ? 'runtime' : 'concrete';
    let field;
    if (dataViewField) {
      if (isExistingRuntimeField) {
        var _dataView$getFormatte;
        // Runtime field
        field = {
          name: fieldNameToEdit,
          customLabel: dataViewField.customLabel,
          customDescription: dataViewField.customDescription,
          popularity: dataViewField.count,
          format: (_dataView$getFormatte = dataView.getFormatterForFieldNoDefault(fieldNameToEdit)) === null || _dataView$getFormatte === void 0 ? void 0 : _dataView$getFormatte.toJSON(),
          ...dataView.getRuntimeField(fieldNameToEdit)
        };
      } else {
        var _dataView$getFormatte2;
        // Concrete field
        field = {
          name: fieldNameToEdit,
          type: dataViewField !== null && dataViewField !== void 0 && dataViewField.esTypes ? dataViewField.esTypes[0] : 'keyword',
          customLabel: dataViewField.customLabel,
          customDescription: dataViewField.customDescription,
          popularity: dataViewField.count,
          format: (_dataView$getFormatte2 = dataView.getFormatterForFieldNoDefault(fieldNameToEdit)) === null || _dataView$getFormatte2 === void 0 ? void 0 : _dataView$getFormatte2.toJSON(),
          parentName: dataViewField.spec.parentName
        };
      }
    }
    overlayRef = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, null, /*#__PURE__*/_react.default.createElement(_field_editor_loader.FieldEditorLoader, {
      onSave: onSaveField,
      onCancel: closeEditor,
      onMounted: onMounted,
      docLinks: docLinks,
      fieldToEdit: field,
      fieldToCreate: fieldToCreate,
      fieldTypeToProcess: fieldTypeToProcess,
      dataView: dataView,
      search: search,
      dataViews: dataViews,
      notifications: notifications,
      usageCollection: usageCollection,
      apiService: apiService,
      fieldFormatEditors: fieldFormatEditors,
      fieldFormats: fieldFormats,
      uiSettings: uiSettings
    })), core), {
      className: _constants.euiFlyoutClassname,
      maxWidth: 708,
      size: 'l',
      ownFocus: true,
      hideCloseButton: true,
      'aria-label': isNewRuntimeField ? _i18n.i18n.translate('indexPatternFieldEditor.createField.flyoutAriaLabel', {
        defaultMessage: 'Create field'
      }) : _i18n.i18n.translate('indexPatternFieldEditor.editField.flyoutAriaLabel', {
        defaultMessage: 'Edit {fieldName} field',
        values: {
          fieldName: fieldNameToEdit
        }
      }),
      onClose: flyout => {
        const canClose = canCloseValidator.current();
        if (canClose) {
          flyout.close();
        }
      },
      maskProps: {
        className: 'indexPatternFieldEditorMaskOverlay',
        // // EUI TODO: This z-index override of EuiOverlayMask is a workaround, and ideally should be resolved with a cleaner UI/UX flow long-term
        style: 'z-index: 1003' // we need this flyout to be above the timeline flyout (which has a z-index of 1002)
      }
    });
    return closeEditor;
  };
  return openEditor(options);
};
exports.getFieldEditorOpener = getFieldEditorOpener;