"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initApi = void 0;
var _constants = require("../../common/constants");
var _shared_imports = require("../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const initApi = httpClient => {
  const getFieldPreview = ({
    index,
    context,
    script,
    document
  }) => {
    return (0, _shared_imports.sendRequest)(httpClient, {
      path: _constants.FIELD_PREVIEW_PATH,
      method: 'post',
      body: {
        index,
        context,
        script,
        document
      },
      version: _constants.INITIAL_REST_VERSION
    });
  };
  return {
    getFieldPreview
  };
};
exports.initApi = initApi;