"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewListItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _field_preview_context = require("../field_preview_context");
var _is_updating_indicator = require("../is_updating_indicator");
var _image_preview_modal = require("../image_preview_modal");
var _state_utils = require("../../../state_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isLoadingPreviewSelector = state => state.isLoadingPreview;
const PreviewListItem = ({
  field: {
    key,
    value,
    formattedValue,
    isPinned = false
  },
  toggleIsPinned,
  hasScriptError,
  isFromScript = false
}) => {
  const {
    controller
  } = (0, _field_preview_context.useFieldPreviewContext)();
  const isLoadingPreview = (0, _state_utils.useStateSelector)(controller.state$, isLoadingPreviewSelector);
  const [isPreviewImageModalVisible, setIsPreviewImageModalVisible] = (0, _react.useState)(false);
  const classes = (0, _classnames.default)('indexPatternFieldEditor__previewFieldList__item', {
    'indexPatternFieldEditor__previewFieldList__item--highlighted': isFromScript,
    'indexPatternFieldEditor__previewFieldList__item--pinned': isPinned
  });
  const doesContainImage = formattedValue === null || formattedValue === void 0 ? void 0 : formattedValue.includes('<img');
  const renderName = () => {
    if (isFromScript && !Boolean(key)) {
      return /*#__PURE__*/_react.default.createElement("span", {
        className: "indexPatternFieldEditor__previewFieldList--ligthWeight"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.fieldNameNotSetLabel', {
        defaultMessage: 'Field name not set'
      })));
    }
    return key;
  };
  const withTooltip = content => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: typeof value !== 'string' ? JSON.stringify(value) : value
  }, content);
  const renderValue = () => {
    if (isFromScript && isLoadingPreview) {
      return /*#__PURE__*/_react.default.createElement("span", {
        className: "indexPatternFieldEditor__previewFieldList--ligthWeight"
      }, /*#__PURE__*/_react.default.createElement(_is_updating_indicator.IsUpdatingIndicator, null));
    }
    if (hasScriptError) {
      return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        iconType: "warning",
        color: "danger",
        "data-test-subj": "scriptErrorBadge"
      }, _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.scriptErrorBadgeLabel', {
        defaultMessage: 'Script error'
      })));
    }
    if (isFromScript && value === undefined) {
      return /*#__PURE__*/_react.default.createElement("span", {
        className: "indexPatternFieldEditor__previewFieldList--ligthWeight"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.valueNotSetLabel', {
        defaultMessage: 'Value not set'
      })));
    }
    if (doesContainImage) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        color: "text",
        onClick: () => setIsPreviewImageModalVisible(true),
        iconType: "image"
      }, _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.viewImageButtonLabel', {
        defaultMessage: 'View image'
      }));
    }
    if (formattedValue !== undefined) {
      return withTooltip( /*#__PURE__*/_react.default.createElement("span", {
        className: "indexPatternFieldEditor__previewFieldList__item__value__wrapper"
        // We  can dangerously set HTML here because this content is guaranteed to have been run through a valid field formatter first.
        ,
        dangerouslySetInnerHTML: {
          __html: formattedValue
        } // eslint-disable-line react/no-danger
      }));
    }
    return withTooltip( /*#__PURE__*/_react.default.createElement("span", {
      className: "indexPatternFieldEditor__previewFieldList__item__value__wrapper"
    }, JSON.stringify(value)));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: classes,
    gutterSize: "none",
    "data-test-subj": "listItem"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "indexPatternFieldEditor__previewFieldList__item__key"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "indexPatternFieldEditor__previewFieldList__item__key__wrapper",
    "data-test-subj": "key"
  }, renderName())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "indexPatternFieldEditor__previewFieldList__item__value",
    "data-test-subj": "value"
  }, renderValue()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "indexPatternFieldEditor__previewFieldList__item__actions",
    grow: false
  }, toggleIsPinned && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: () => {
      toggleIsPinned(key);
    },
    color: "text",
    iconType: "pinFilled",
    "data-test-subj": "pinFieldButton",
    "aria-label": _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.pinFieldButtonLabel', {
      defaultMessage: 'Pin field'
    }),
    className: "indexPatternFieldEditor__previewFieldList__item__actionsBtn"
  }))), isPreviewImageModalVisible && /*#__PURE__*/_react.default.createElement(_image_preview_modal.ImagePreviewModal, {
    imgHTML: formattedValue,
    closeModal: () => setIsPreviewImageModalVisible(false)
  }));
};
exports.PreviewListItem = PreviewListItem;