"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlFormatEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _samples = require("../../samples");
var _default = require("../default/default");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class UrlFormatEditor extends _default.DefaultFormatEditor {
  get sampleIconPath() {
    var _this$context;
    const sampleIconPath = `/plugins/dataViewFieldEditor/assets/icons/{{value}}.png`;
    return (_this$context = this.context) !== null && _this$context !== void 0 && _this$context.services.http ? this.context.services.http.basePath.prepend(sampleIconPath) : sampleIconPath;
  }
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "sanitizeNumericValue", val => {
      const sanitizedValue = parseInt(val, 10);
      if (isNaN(sanitizedValue)) {
        return '';
      }
      return sanitizedValue;
    });
    (0, _defineProperty2.default)(this, "onTypeChange", newType => {
      const {
        urlTemplate,
        width,
        height
      } = this.props.formatParams;
      const params = {
        type: newType
      };
      if (newType === 'img') {
        params.width = width;
        params.height = height;
        if (!urlTemplate) {
          params.urlTemplate = this.sampleIconPath;
        }
      } else if (newType !== 'img' && urlTemplate === this.sampleIconPath) {
        params.urlTemplate = undefined;
      }
      this.onChange(params);
    });
    (0, _defineProperty2.default)(this, "renderWidthHeightParameters", () => {
      const width = this.sanitizeNumericValue(this.props.formatParams.width);
      const height = this.sanitizeNumericValue(this.props.formatParams.height);
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "indexPatternFieldEditor.url.widthLabel",
          defaultMessage: "Width"
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
        "data-test-subj": "urlEditorWidth",
        value: width,
        onChange: e => {
          this.onChange({
            width: e.target.value
          });
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "indexPatternFieldEditor.url.heightLabel",
          defaultMessage: "Height"
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
        "data-test-subj": "urlEditorHeight",
        value: height,
        onChange: e => {
          this.onChange({
            height: e.target.value
          });
        }
      })));
    });
    this.state = {
      ...this.state,
      sampleInputsByType: {
        a: ['john', '/some/pathname/asset.png', 1234],
        img: ['go', 'stop', ['de', 'ne', 'us', 'ni'], 'cv'],
        audio: ['hello.mp3']
      },
      sampleConverterType: 'html',
      showUrlTemplateHelp: false,
      showLabelTemplateHelp: false
    };
  }
  render() {
    var _formatParams$type;
    const {
      formatParams,
      format
    } = this.props;
    const {
      error,
      samples,
      sampleConverterType
    } = this.state;
    const urlType = (_formatParams$type = formatParams.type) !== null && _formatParams$type !== void 0 ? _formatParams$type : `${format.getParamDefaults().type}`;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.url.typeLabel",
        defaultMessage: "Type"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-test-subj": "urlEditorType",
      value: urlType,
      options: format.type.urlTypes.map(type => {
        return {
          value: type.kind,
          text: type.text
        };
      }),
      onChange: e => {
        this.onTypeChange(e.target.value);
      }
    })), urlType === 'a' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.url.openTabLabel",
        defaultMessage: "Open in a new tab"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: formatParams.openLinkInCurrentTab ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.url.offLabel",
        defaultMessage: "Off"
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.url.onLabel",
        defaultMessage: "On"
      }),
      checked: !formatParams.openLinkInCurrentTab,
      onChange: e => {
        this.onChange({
          openLinkInCurrentTab: !e.target.checked
        });
      }
    })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.url.urlTemplateLabel",
        defaultMessage: "URL template"
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: this.context.services.docLinks.links.indexPatterns.fieldFormattersString
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.url.template.helpLinkText",
        defaultMessage: "URL template help"
      })),
      isInvalid: !!error,
      error: error
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": "urlEditorUrlTemplate",
      value: formatParams.urlTemplate || '',
      onChange: e => {
        this.onChange({
          urlTemplate: e.target.value
        });
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.url.labelTemplateLabel",
        defaultMessage: "Label template"
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: this.context.services.docLinks.links.indexPatterns.fieldFormattersString
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.url.labelTemplateHelpText",
        defaultMessage: "Label template help"
      })),
      isInvalid: !!error,
      error: error
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": "urlEditorLabelTemplate",
      value: formatParams.labelTemplate || '',
      onChange: e => {
        this.onChange({
          labelTemplate: e.target.value
        });
      }
    })), urlType === 'img' && this.renderWidthHeightParameters(), /*#__PURE__*/_react.default.createElement(_samples.FormatEditorSamples, {
      samples: samples,
      sampleType: sampleConverterType
    }));
  }
}
exports.UrlFormatEditor = UrlFormatEditor;
(0, _defineProperty2.default)(UrlFormatEditor, "contextType", _public.context);
(0, _defineProperty2.default)(UrlFormatEditor, "formatId", _constants.formatId);