"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StaticLookupFormatEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _default = require("../default/default");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class StaticLookupFormatEditor extends _default.DefaultFormatEditor {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "onLookupChange", (newLookupParams, index) => {
      const lookupEntries = [...this.props.formatParams.lookupEntries];
      lookupEntries[index] = {
        ...lookupEntries[index],
        ...newLookupParams
      };
      this.onChange({
        lookupEntries
      });
    });
    (0, _defineProperty2.default)(this, "addLookup", () => {
      const lookupEntries = [...(this.props.formatParams.lookupEntries || [])];
      this.onChange({
        lookupEntries: [...lookupEntries, {}]
      });
    });
    (0, _defineProperty2.default)(this, "removeLookup", index => {
      const lookupEntries = [...this.props.formatParams.lookupEntries];
      lookupEntries.splice(index, 1);
      this.onChange({
        lookupEntries
      });
    });
  }
  render() {
    const {
      formatParams
    } = this.props;
    const items = formatParams.lookupEntries && formatParams.lookupEntries.length && formatParams.lookupEntries.map((lookup, index) => {
      return {
        ...lookup,
        index
      };
    }) || [];
    const columns = [{
      field: 'key',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.staticLookup.keyLabel",
        defaultMessage: "Key"
      }),
      render: (value, item) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          value: value || '',
          "data-test-subj": `staticLookupEditorKey ${item.index}`,
          onChange: e => {
            this.onLookupChange({
              key: e.target.value
            }, item.index);
          }
        });
      }
    }, {
      field: 'value',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.staticLookup.valueLabel",
        defaultMessage: "Value"
      }),
      render: (value, item) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          value: value || '',
          "data-test-subj": `staticLookupEditorValue ${item.index}`,
          onChange: e => {
            this.onLookupChange({
              value: e.target.value
            }, item.index);
          }
        });
      }
    }, {
      field: 'actions',
      name: _i18n.i18n.translate('indexPatternFieldEditor.staticLookup.actions', {
        defaultMessage: 'actions'
      }),
      actions: [{
        name: _i18n.i18n.translate('indexPatternFieldEditor.staticLookup.deleteAria', {
          defaultMessage: 'Delete'
        }),
        description: _i18n.i18n.translate('indexPatternFieldEditor.staticLookup.deleteTitle', {
          defaultMessage: 'Delete entry'
        }),
        onClick: item => {
          this.removeLookup(item.index);
        },
        type: 'icon',
        icon: 'trash',
        color: 'danger',
        'data-test-subj': 'staticLookupEditorRemoveEntry',
        available: () => items.length > 1
      }],
      width: '30px'
    }];
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      items: items,
      columns: columns,
      style: {
        maxWidth: '400px'
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "plusInCircle",
      size: "s",
      onClick: this.addLookup,
      "data-test-subj": 'staticLookupEditorAddEntry'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternFieldEditor.staticLookup.addEntryButton",
      defaultMessage: "Add entry"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.staticLookup.unknownKeyLabel",
        defaultMessage: "Value for unknown key"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: formatParams.unknownKeyValue || '',
      "data-test-subj": 'staticLookupEditorUnknownValue',
      placeholder: _i18n.i18n.translate('indexPatternFieldEditor.staticLookup.leaveBlankPlaceholder', {
        defaultMessage: 'Leave blank to keep value as-is'
      }),
      onChange: e => {
        this.onChange({
          unknownKeyValue: e.target.value
        });
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }
}
exports.StaticLookupFormatEditor = StaticLookupFormatEditor;
(0, _defineProperty2.default)(StaticLookupFormatEditor, "formatId", _constants.formatId);