"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldEditorFlyoutContentContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _lib = require("../lib");
var _field_editor_flyout_content = require("./field_editor_flyout_content");
var _field_editor_context = require("./field_editor_context");
var _preview = require("./preview");
var _preview_controller = require("./preview/preview_controller");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * The container component will be in charge of the communication with the index pattern service
 * to retrieve/save the field in the saved object.
 * The <FieldEditorFlyoutContent /> component is the presentational component that won't know
 * anything about where a field comes from and where it should be persisted.
 */

const FieldEditorFlyoutContentContainer = ({
  fieldToEdit,
  fieldToCreate,
  onSave,
  onCancel,
  onMounted,
  docLinks,
  fieldTypeToProcess,
  dataView,
  dataViews,
  search,
  notifications,
  usageCollection,
  apiService,
  fieldFormatEditors,
  fieldFormats,
  uiSettings
}) => {
  const [controller] = (0, _react.useState)(() => new _preview_controller.PreviewController({
    deps: {
      dataViews,
      search,
      fieldFormats,
      usageCollection,
      notifications
    },
    dataView,
    onSave,
    fieldToEdit,
    fieldTypeToProcess
  }));
  const services = (0, _react.useMemo)(() => ({
    api: apiService,
    search,
    notifications
  }), [apiService, search, notifications]);
  return /*#__PURE__*/_react.default.createElement(_field_editor_context.FieldEditorProvider, {
    dataView: dataView,
    uiSettings: uiSettings,
    links: (0, _lib.getLinks)(docLinks),
    fieldTypeToProcess: fieldTypeToProcess,
    services: services,
    fieldFormatEditors: fieldFormatEditors,
    fieldFormats: fieldFormats,
    namesNotAllowed: controller.getNamesNotAllowed(),
    existingConcreteFields: controller.getExistingConcreteFields(),
    fieldName$: new _rxjs.BehaviorSubject((fieldToEdit === null || fieldToEdit === void 0 ? void 0 : fieldToEdit.name) || ''),
    subfields$: new _rxjs.BehaviorSubject(fieldToEdit === null || fieldToEdit === void 0 ? void 0 : fieldToEdit.fields)
  }, /*#__PURE__*/_react.default.createElement(_preview.FieldPreviewProvider, {
    controller: controller
  }, /*#__PURE__*/_react.default.createElement(_field_editor_flyout_content.FieldEditorFlyoutContent, {
    onSave: controller.saveField,
    onCancel: onCancel,
    onMounted: onMounted,
    fieldToCreate: fieldToCreate,
    fieldToEdit: fieldToEdit
  })));
};
exports.FieldEditorFlyoutContentContainer = FieldEditorFlyoutContentContainer;