"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TypeField = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-views-plugin/public");
var _rollup = require("@kbn/rollup");
var _shared_imports = require("../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const standardSelectItem = /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
  style: {
    whiteSpace: 'nowrap'
  },
  "data-test-subj": "standardType"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.typeSelect.standardTitle",
  defaultMessage: "Standard data view"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.typeSelect.standardDescription",
  defaultMessage: "Perform full aggregations against any data"
})));
const rollupSelectItem = /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
  style: {
    whiteSpace: 'nowrap'
  },
  "data-test-subj": "rollupType"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.typeSelect.rollupTitle",
  defaultMessage: "Rollup data view"
}), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  color: _uiTheme.euiLightVars.euiColorAccent
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.typeSelect.betaLabel",
  defaultMessage: "Beta"
})), "\xA0", /*#__PURE__*/_react.default.createElement(_rollup.RollupDeprecationTooltip, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  color: "warning"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.typeSelect.deprecatedBadge",
  defaultMessage: "Deprecated"
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.typeSelect.rollupDescription",
  defaultMessage: "Perform limited aggregations against summarized data"
})));
const TypeField = ({
  onChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "type"
  }, ({
    label,
    value,
    setValue
  }) => {
    if (value === undefined) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: label,
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      "data-test-subj": "typeField",
      options: [{
        value: _public.INDEX_PATTERN_TYPE.DEFAULT,
        inputDisplay: _i18n.i18n.translate('indexPatternEditor.typeSelect.standard', {
          defaultMessage: 'Standard'
        }),
        dropdownDisplay: standardSelectItem
      }, {
        value: _public.INDEX_PATTERN_TYPE.ROLLUP,
        inputDisplay: _i18n.i18n.translate('indexPatternEditor.typeSelect.rollup', {
          defaultMessage: 'Rollup (deprecated)'
        }),
        dropdownDisplay: rollupSelectItem
      }],
      valueOfSelected: value,
      onChange: newValue => {
        setValue(newValue);
        onChange(newValue);
      },
      "aria-label": _i18n.i18n.translate('indexPatternEditor.editor.form.typeSelectAriaLabel', {
        defaultMessage: 'Type field'
      }),
      fullWidth: true
    })));
  });
};
exports.TypeField = TypeField;