"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamSpacesAdapter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _create_or_update_component_template = require("./create_or_update_component_template");
var _create_or_update_data_stream = require("./create_or_update_data_stream");
var _create_or_update_index_template = require("./create_or_update_index_template");
var _data_stream_adapter = require("./data_stream_adapter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class DataStreamSpacesAdapter extends _data_stream_adapter.DataStreamAdapter {
  constructor(prefix, options) {
    super(`${prefix}-*`, options); // make indexTemplate `indexPatterns` match all data stream space names
    (0, _defineProperty2.default)(this, "installedSpaceDataStreamName", void 0);
    (0, _defineProperty2.default)(this, "_installSpace", void 0);
    this.prefix = prefix;
    this.installedSpaceDataStreamName = new Map();
  }
  async install({
    logger,
    esClient: esClientToResolve,
    pluginStop$,
    tasksTimeoutMs
  }) {
    this.installed = true;
    const esClient = await esClientToResolve;
    const installFn = this.getInstallFn({
      logger,
      pluginStop$,
      tasksTimeoutMs
    });

    // Install component templates in parallel
    await Promise.all(this.componentTemplates.map(componentTemplate => installFn((0, _create_or_update_component_template.createOrUpdateComponentTemplate)({
      template: componentTemplate,
      esClient,
      logger,
      totalFieldsLimit: this.totalFieldsLimit
    }), `create or update ${componentTemplate.name} component template`)));

    // Install index templates in parallel
    await Promise.all(this.indexTemplates.map(indexTemplate => installFn((0, _create_or_update_index_template.createOrUpdateIndexTemplate)({
      template: indexTemplate,
      esClient,
      logger
    }), `create or update ${indexTemplate.name} index template`)));

    // Update existing space data streams
    await installFn((0, _create_or_update_data_stream.updateDataStreams)({
      name: `${this.prefix}-*`,
      esClient,
      logger,
      totalFieldsLimit: this.totalFieldsLimit
    }), `update space data streams`);

    // define function to install data stream for spaces on demand
    this._installSpace = async spaceId => {
      const existingInstallPromise = this.installedSpaceDataStreamName.get(spaceId);
      if (existingInstallPromise) {
        return existingInstallPromise;
      }
      const name = `${this.prefix}-${spaceId}`;
      const installPromise = installFn((0, _create_or_update_data_stream.createDataStream)({
        name,
        esClient,
        logger
      }), `create ${name} data stream`).then(() => name);
      this.installedSpaceDataStreamName.set(spaceId, installPromise);
      return installPromise;
    };
  }
  async installSpace(spaceId) {
    if (!this._installSpace) {
      throw new Error('Cannot installSpace before install');
    }
    return this._installSpace(spaceId);
  }
  async getInstalledSpaceName(spaceId) {
    return this.installedSpaceDataStreamName.get(spaceId);
  }
}
exports.DataStreamSpacesAdapter = DataStreamSpacesAdapter;