"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumbs = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBreadcrumbs = (breadcrumb, params, chromeService) => {
  const {
    docTitle
  } = chromeService;
  docTitle.change(breadcrumb);
  (0, _react.useEffect)(() => {
    params.setBreadcrumbs([{
      text: breadcrumb
    }]);
  }, [breadcrumb, params]);
};
exports.useBreadcrumbs = useBreadcrumbs;