"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataQualityPlugin = void 0;
var _constants = require("@kbn/deeplinks-management/constants");
var _common = require("../common");
var _locators = require("../common/locators");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class DataQualityPlugin {
  setup(core, plugins) {
    const {
      management,
      share
    } = plugins;
    const useHash = core.uiSettings.get('state:storeInSessionStorage');
    management.sections.section.data.registerApp({
      id: _common.PLUGIN_ID,
      title: _common.PLUGIN_NAME,
      order: 2,
      keywords: ['data', 'quality', 'data quality', 'datasets', 'datasets quality', 'data set quality'],
      async mount(params) {
        const [{
          renderApp
        }, [coreStart, pluginsStartDeps, pluginStart]] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./application'))), core.getStartServices()]);
        return renderApp(coreStart, pluginsStartDeps, pluginStart, params);
      },
      hideFromSidebar: false
    });
    const managementLocator = share.url.locators.get(_constants.MANAGEMENT_APP_LOCATOR);
    if (managementLocator) {
      share.url.locators.create(new _locators.DatasetQualityLocatorDefinition({
        useHash,
        managementLocator
      }));
    }
    return {};
  }
  start(_core) {
    return {};
  }
  stop() {}
}
exports.DataQualityPlugin = DataQualityPlugin;