"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.urlSchemaRT = exports.tableRT = exports.sortRT = exports.flyoutRT = exports.filtersRT = exports.directionRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const directionRT = exports.directionRT = rt.keyof({
  asc: null,
  desc: null
});
const sortRT = exports.sortRT = rt.strict({
  field: rt.string,
  direction: directionRT
});
const tableRT = exports.tableRT = rt.exact(rt.partial({
  page: rt.number,
  rowsPerPage: rt.number,
  sort: sortRT
}));
const integrationRT = rt.strict({
  name: rt.string,
  title: rt.string,
  version: rt.string
});
const datasetRT = rt.intersection([rt.strict({
  rawName: rt.string,
  type: rt.string,
  name: rt.string,
  namespace: rt.string,
  title: rt.string
}), rt.exact(rt.partial({
  integration: integrationRT
}))]);
const timeRangeRT = rt.strict({
  from: rt.string,
  to: rt.string,
  refresh: rt.strict({
    pause: rt.boolean,
    value: rt.number
  })
});
const degradedFieldRT = rt.exact(rt.partial({
  table: tableRT
}));
const flyoutRT = exports.flyoutRT = rt.exact(rt.partial({
  dataset: datasetRT,
  insightsTimeRange: timeRangeRT,
  breakdownField: rt.string,
  degradedFields: degradedFieldRT
}));
const filtersRT = exports.filtersRT = rt.exact(rt.partial({
  inactive: rt.boolean,
  fullNames: rt.boolean,
  timeRange: timeRangeRT,
  integrations: rt.array(rt.string),
  namespaces: rt.array(rt.string),
  qualities: rt.array(rt.union([rt.literal('poor'), rt.literal('degraded'), rt.literal('good')])),
  query: rt.string
}));
const urlSchemaRT = exports.urlSchemaRT = rt.exact(rt.partial({
  v: rt.literal(1),
  table: tableRT,
  flyout: flyoutRT,
  filters: filtersRT
}));