"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchSessionsUpdateSchema = exports.searchSessionsFindSchema = exports.searchSessionStatusSchema = exports.searchSessionSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const searchSessionRequestInfoSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  strategy: _configSchema.schema.string()
});
const serializeableSchema = _configSchema.schema.mapOf(_configSchema.schema.string(), _configSchema.schema.any());
const searchSessionAttrSchema = () => _configSchema.schema.object({
  sessionId: _configSchema.schema.string(),
  name: _configSchema.schema.maybe(_configSchema.schema.string()),
  appId: _configSchema.schema.maybe(_configSchema.schema.string()),
  created: _configSchema.schema.string(),
  expires: _configSchema.schema.string(),
  locatorId: _configSchema.schema.maybe(_configSchema.schema.string()),
  initialState: _configSchema.schema.maybe(serializeableSchema),
  restoreState: _configSchema.schema.maybe(serializeableSchema),
  idMapping: _configSchema.schema.mapOf(_configSchema.schema.string(), searchSessionRequestInfoSchema),
  realmType: _configSchema.schema.maybe(_configSchema.schema.string()),
  realmName: _configSchema.schema.maybe(_configSchema.schema.string()),
  username: _configSchema.schema.maybe(_configSchema.schema.string()),
  version: _configSchema.schema.string(),
  isCanceled: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const searchSessionSchema = () => _configSchema.schema.object({
  id: _configSchema.schema.string(),
  attributes: searchSessionAttrSchema()
});
exports.searchSessionSchema = searchSessionSchema;
const searchSessionStatusSchema = () => _configSchema.schema.object({
  status: _configSchema.schema.oneOf([_configSchema.schema.literal('in_progress'), _configSchema.schema.literal('error'), _configSchema.schema.literal('complete'), _configSchema.schema.literal('cancelled'), _configSchema.schema.literal('expired')]),
  errors: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
});
exports.searchSessionStatusSchema = searchSessionStatusSchema;
const searchSessionsFindSchema = () => _configSchema.schema.object({
  total: _configSchema.schema.number(),
  saved_objects: _configSchema.schema.arrayOf(searchSessionSchema()),
  statuses: _configSchema.schema.recordOf(_configSchema.schema.string(), searchSessionStatusSchema())
});
exports.searchSessionsFindSchema = searchSessionsFindSchema;
const referencesSchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
  id: _configSchema.schema.string(),
  type: _configSchema.schema.string(),
  name: _configSchema.schema.string()
}));
const searchSessionsUpdateSchema = () => _configSchema.schema.object({
  id: _configSchema.schema.string(),
  type: _configSchema.schema.string(),
  updated_at: _configSchema.schema.maybe(_configSchema.schema.string()),
  version: _configSchema.schema.maybe(_configSchema.schema.string()),
  namespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  references: _configSchema.schema.maybe(referencesSchema),
  attributes: _configSchema.schema.object({
    name: _configSchema.schema.maybe(_configSchema.schema.string()),
    expires: _configSchema.schema.maybe(_configSchema.schema.string())
  })
});
exports.searchSessionsUpdateSchema = searchSessionsUpdateSchema;