"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KbnSearchError = void 0;
exports.getKbnSearchError = getKbnSearchError;
exports.reportSearchError = reportSearchError;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _elasticsearch = require("@elastic/elasticsearch");
var _common = require("@kbn/kibana-utils-plugin/common");
var _sanitize_request_params = require("./sanitize_request_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Why not use just use kibana-utils-plugin KbnServerError and reportServerError?
//
// Search errors need to surface additional information
// such as rawResponse and sanitized requestParams.
// KbnServerError and reportServerError are used widely throughtout Kibana.
// KbnSearchError and reportSearchError exist to avoid polluting
// non-search usages of KbnServerError and reportServerError with extra information.
class KbnSearchError extends _common.KbnError {
  constructor(message, statusCode, errBody, requestParams) {
    super(message);
    (0, _defineProperty2.default)(this, "errBody", void 0);
    (0, _defineProperty2.default)(this, "requestParams", void 0);
    this.statusCode = statusCode;
    this.errBody = errBody;
    this.requestParams = requestParams ? (0, _sanitize_request_params.sanitizeRequestParams)(requestParams) : undefined;
  }
}

/**
 * Formats any error thrown into a standardized `KbnSearchError`.
 * @param e `Error` or `ElasticsearchClientError`
 * @returns `KbnSearchError`
 */
exports.KbnSearchError = KbnSearchError;
function getKbnSearchError(e) {
  var _e$message, _e$meta, _e$meta$meta, _e$meta$meta$request;
  if (e instanceof KbnSearchError) return e;
  return new KbnSearchError((_e$message = e.message) !== null && _e$message !== void 0 ? _e$message : 'Unknown error', e instanceof _elasticsearch.errors.ResponseError ? e.statusCode : 500, e instanceof _elasticsearch.errors.ResponseError ? e.body : undefined, e instanceof _elasticsearch.errors.ResponseError ? (_e$meta = e.meta) === null || _e$meta === void 0 ? void 0 : (_e$meta$meta = _e$meta.meta) === null || _e$meta$meta === void 0 ? void 0 : (_e$meta$meta$request = _e$meta$meta.request) === null || _e$meta$meta$request === void 0 ? void 0 : _e$meta$meta$request.params : undefined);
}

/**
 *
 * @param res Formats a `KbnSearchError` into a server error response
 * @param err
 */
function reportSearchError(res, err) {
  var _err$statusCode;
  return res.customError({
    statusCode: (_err$statusCode = err.statusCode) !== null && _err$statusCode !== void 0 ? _err$statusCode : 500,
    body: {
      message: err.message,
      attributes: err.errBody ? {
        error: err.errBody.error,
        rawResponse: err.errBody.response,
        ...(err.requestParams ? {
          requestParams: err.requestParams
        } : {})
      } : undefined
    }
  });
}