"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataDownloadOptions = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/share-plugin/public");
var _common = require("../../../../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const detectFormulasInTables = (0, _lodash.memoize)(datatables => datatables.some(({
  columns,
  rows
}) => (0, _common.tableHasFormulas)(columns, rows)));
class DataDownloadOptions extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "onTogglePopover", () => {
      this.setState(state => ({
        isPopoverOpen: !state.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "exportCsv", (isFormatted = true) => {
      let filename = this.props.title;
      if (!filename || filename.length === 0) {
        filename = _i18n.i18n.translate('data.inspector.table.downloadOptionsUnsavedFilename', {
          defaultMessage: 'unsaved'
        });
      }
      const content = this.props.datatables.reduce((memo, datatable, i) => {
        // skip empty datatables
        if (datatable) {
          const postFix = this.props.datatables.length > 1 ? `-${i + 1}` : '';
          memo[`${filename}${postFix}.csv`] = {
            content: (0, _common.datatableToCSV)(datatable, {
              csvSeparator: this.props.uiSettings.get('csv:separator', ','),
              quoteValues: this.props.uiSettings.get('csv:quoteValues', true),
              raw: !isFormatted,
              formatFactory: this.props.fieldFormats.deserialize,
              escapeFormulaValues: false
            }),
            type: _common.CSV_MIME_TYPE
          };
        }
        return memo;
      }, {});
      if (content) {
        (0, _public.downloadMultipleAs)(content);
      }
    });
    (0, _defineProperty2.default)(this, "exportFormattedCsv", () => {
      this.exportCsv(true);
    });
    (0, _defineProperty2.default)(this, "exportFormattedAsRawCsv", () => {
      this.exportCsv(false);
    });
  }
  renderFormattedDownloads() {
    const detectedFormulasInTables = detectFormulasInTables(this.props.datatables);
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "arrowDown",
      iconSide: "right",
      size: "s",
      onClick: this.onTogglePopover
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "data.inspector.table.downloadCSVToggleButtonLabel",
      defaultMessage: "Download CSV"
    }));
    const downloadButton = detectedFormulasInTables ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('data.inspector.table.exportButtonFormulasWarning', {
        defaultMessage: 'Your CSV contains characters that spreadsheet applications might interpret as formulas.'
      })
    }, button) : button;
    const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "csv",
      onClick: this.exportFormattedCsv,
      toolTipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "data.inspector.table.formattedCSVButtonTooltip",
        defaultMessage: "Download the data in table format"
      }),
      toolTipProps: {
        position: 'left'
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "data.inspector.table.formattedCSVButtonLabel",
      defaultMessage: "Formatted CSV"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "rawCsv",
      onClick: this.exportFormattedAsRawCsv,
      toolTipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "data.inspector.table.rawCSVButtonTooltip",
        defaultMessage: "Download the data as provided, for example, dates as timestamps"
      }),
      toolTipProps: {
        position: 'left'
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "data.inspector.table.rawCSVButtonLabel",
      defaultMessage: "Raw CSV"
    }))];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "inspectorDownloadData",
      button: downloadButton,
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover,
      panelPaddingSize: "none",
      repositionOnScroll: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      className: "eui-textNoWrap",
      items: items
    }));
  }
  render() {
    return this.renderFormattedDownloads();
  }
}
exports.DataDownloadOptions = DataDownloadOptions;
(0, _defineProperty2.default)(DataDownloadOptions, "propTypes", {
  title: _propTypes.default.string.isRequired,
  uiSettings: _propTypes.default.object.isRequired,
  datatables: _propTypes.default.array,
  fieldFormats: _propTypes.default.object.isRequired
});