"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionsClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const version = '1';
const options = {
  version
};

/**
 * CRUD Search Session SO
 */
class SessionsClient {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "http", void 0);
    this.http = deps.http;
  }
  get(sessionId) {
    return this.http.get(`/internal/session/${encodeURIComponent(sessionId)}`, options);
  }
  create({
    name,
    appId,
    locatorId,
    initialState,
    restoreState,
    sessionId
  }) {
    return this.http.post(`/internal/session`, {
      version,
      body: JSON.stringify({
        name,
        appId,
        locatorId,
        initialState,
        restoreState,
        sessionId
      })
    });
  }
  find(opts) {
    return this.http.post(`/internal/session/_find`, {
      version,
      body: JSON.stringify(opts)
    });
  }
  update(sessionId, attributes) {
    return this.http.put(`/internal/session/${encodeURIComponent(sessionId)}`, {
      version,
      body: JSON.stringify(attributes)
    });
  }
  async rename(sessionId, newName) {
    await this.update(sessionId, {
      name: newName
    });
  }
  async extend(sessionId, expires) {
    await this.http.post(`/internal/session/${encodeURIComponent(sessionId)}/_extend`, {
      version,
      body: JSON.stringify({
        expires
      })
    });
  }
  delete(sessionId) {
    return this.http.delete(`/internal/session/${encodeURIComponent(sessionId)}`, options);
  }
}
exports.SessionsClient = SessionsClient;