"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRangeDisplayValue = getRangeDisplayValue;
exports.mapRange = exports.isMapRangeFilter = void 0;
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getRangeDisplayValue({
  meta: {
    params
  }
}, formatter) {
  const convert = formatter ? formatter.getConverterFor('text') : _lodash.identity;
  const {
    gte,
    gt,
    lte,
    lt
  } = params || {};
  const left = gte !== null && gte !== void 0 ? gte : gt;
  const right = lte !== null && lte !== void 0 ? lte : lt;
  if (left !== undefined && right !== undefined) {
    return `${convert(left)} to ${convert(right)}`;
  }
  if (gte !== undefined) {
    return `≥ ${convert(gte)}`;
  }
  if (gt !== undefined) {
    return `> ${convert(gt)}`;
  }
  if (lte !== undefined) {
    return `≤ ${convert(lte)}`;
  }
  if (lt !== undefined) {
    return `< ${convert(lt)}`;
  }
  return '-';
}
const getFirstRangeKey = filter => filter.query.range && Object.keys(filter.query.range)[0];
const getRangeByKey = (filter, key) => (0, _lodash.get)(filter.query, ['range', key]);
function getParams(filter) {
  const isScriptedRange = (0, _esQuery.isScriptedRangeFilter)(filter);
  const key = (isScriptedRange ? filter.meta.field : getFirstRangeKey(filter)) || '';
  const params = isScriptedRange ? (0, _lodash.get)(filter.query, 'script.script.params') : getRangeByKey(filter, key);
  return {
    type: _esQuery.FILTERS.RANGE,
    key,
    value: params,
    params
  };
}
const isMapRangeFilter = filter => (0, _esQuery.isRangeFilter)(filter) || (0, _esQuery.isScriptedRangeFilter)(filter);
exports.isMapRangeFilter = isMapRangeFilter;
const mapRange = filter => {
  if (!isMapRangeFilter(filter)) {
    throw filter;
  }
  return getParams(filter);
};
exports.mapRange = mapRange;