"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapExists = void 0;
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const mapExists = filter => {
  if ((0, _esQuery.isExistsFilter)(filter)) {
    return {
      type: _esQuery.FILTERS.EXISTS,
      value: _esQuery.FILTERS.EXISTS,
      key: (0, _lodash.get)(filter, 'query.exists.field')
    };
  }
  throw filter;
};
exports.mapExists = mapExists;