"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapDefault = void 0;
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const mapDefault = filter => {
  const metaProperty = /(^\$|meta)/;
  const key = (0, _lodash.find)((0, _lodash.keys)(filter), item => !item.match(metaProperty));
  if (key) {
    const type = _esQuery.FILTERS.CUSTOM;
    const value = JSON.stringify((0, _lodash.get)(filter, key, {}));
    return {
      type,
      key,
      value
    };
  }
  throw filter;
};
exports.mapDefault = mapDefault;